/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.WorkflowInstanceCollection;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetWorkflowInstancesListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WorkflowInstanceCollection> workflowInstanceCollection;

    @JsonCreator
    public GetWorkflowInstancesListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WorkflowInstanceCollection> workflowInstanceCollection) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workflowInstanceCollection, "workflowInstanceCollection");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workflowInstanceCollection = workflowInstanceCollection;
    }

    public GetWorkflowInstancesListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkflowInstanceCollection> workflowInstanceCollection() {
        return this.workflowInstanceCollection;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowInstancesListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetWorkflowInstancesListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetWorkflowInstancesListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetWorkflowInstancesListResponse withWorkflowInstanceCollection(WorkflowInstanceCollection workflowInstanceCollection) {
        Utils.checkNotNull(workflowInstanceCollection, "workflowInstanceCollection");
        this.workflowInstanceCollection = Optional.ofNullable(workflowInstanceCollection);
        return this;
    }

    public GetWorkflowInstancesListResponse withWorkflowInstanceCollection(Optional<? extends WorkflowInstanceCollection> workflowInstanceCollection) {
        Utils.checkNotNull(workflowInstanceCollection, "workflowInstanceCollection");
        this.workflowInstanceCollection = workflowInstanceCollection;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowInstancesListResponse other = (GetWorkflowInstancesListResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.workflowInstanceCollection, other.workflowInstanceCollection);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.workflowInstanceCollection);
    }

    public String toString() {
        return Utils.toString(GetWorkflowInstancesListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workflowInstanceCollection", this.workflowInstanceCollection);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WorkflowInstanceCollection> workflowInstanceCollection = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workflowInstanceCollection(WorkflowInstanceCollection workflowInstanceCollection) {
            Utils.checkNotNull(workflowInstanceCollection, "workflowInstanceCollection");
            this.workflowInstanceCollection = Optional.ofNullable(workflowInstanceCollection);
            return this;
        }

        public Builder workflowInstanceCollection(Optional<? extends WorkflowInstanceCollection> workflowInstanceCollection) {
            Utils.checkNotNull(workflowInstanceCollection, "workflowInstanceCollection");
            this.workflowInstanceCollection = workflowInstanceCollection;
            return this;
        }

        public GetWorkflowInstancesListResponse build() {
            return new GetWorkflowInstancesListResponse(this.contentType, this.statusCode, this.rawResponse, this.workflowInstanceCollection);
        }
    }
}

