/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.WorkflowTriggerRequirementsSuccess;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetWorkflowTriggerRequirementsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess;

    @JsonCreator
    public GetWorkflowTriggerRequirementsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workflowTriggerRequirementsSuccess, "workflowTriggerRequirementsSuccess");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workflowTriggerRequirementsSuccess = workflowTriggerRequirementsSuccess;
    }

    public GetWorkflowTriggerRequirementsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess() {
        return this.workflowTriggerRequirementsSuccess;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowTriggerRequirementsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetWorkflowTriggerRequirementsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetWorkflowTriggerRequirementsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetWorkflowTriggerRequirementsResponse withWorkflowTriggerRequirementsSuccess(WorkflowTriggerRequirementsSuccess workflowTriggerRequirementsSuccess) {
        Utils.checkNotNull(workflowTriggerRequirementsSuccess, "workflowTriggerRequirementsSuccess");
        this.workflowTriggerRequirementsSuccess = Optional.ofNullable(workflowTriggerRequirementsSuccess);
        return this;
    }

    public GetWorkflowTriggerRequirementsResponse withWorkflowTriggerRequirementsSuccess(Optional<? extends WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess) {
        Utils.checkNotNull(workflowTriggerRequirementsSuccess, "workflowTriggerRequirementsSuccess");
        this.workflowTriggerRequirementsSuccess = workflowTriggerRequirementsSuccess;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowTriggerRequirementsResponse other = (GetWorkflowTriggerRequirementsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.workflowTriggerRequirementsSuccess, other.workflowTriggerRequirementsSuccess);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.workflowTriggerRequirementsSuccess);
    }

    public String toString() {
        return Utils.toString(GetWorkflowTriggerRequirementsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workflowTriggerRequirementsSuccess", this.workflowTriggerRequirementsSuccess);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workflowTriggerRequirementsSuccess(WorkflowTriggerRequirementsSuccess workflowTriggerRequirementsSuccess) {
            Utils.checkNotNull(workflowTriggerRequirementsSuccess, "workflowTriggerRequirementsSuccess");
            this.workflowTriggerRequirementsSuccess = Optional.ofNullable(workflowTriggerRequirementsSuccess);
            return this;
        }

        public Builder workflowTriggerRequirementsSuccess(Optional<? extends WorkflowTriggerRequirementsSuccess> workflowTriggerRequirementsSuccess) {
            Utils.checkNotNull(workflowTriggerRequirementsSuccess, "workflowTriggerRequirementsSuccess");
            this.workflowTriggerRequirementsSuccess = workflowTriggerRequirementsSuccess;
            return this;
        }

        public GetWorkflowTriggerRequirementsResponse build() {
            return new GetWorkflowTriggerRequirementsResponse(this.contentType, this.statusCode, this.rawResponse, this.workflowTriggerRequirementsSuccess);
        }
    }
}

