/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.models.operations;

import com.docusign.iam.sdk.models.components.WorkflowsListSuccess;
import com.docusign.iam.sdk.utils.Response;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class GetWorkflowsListResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WorkflowsListSuccess> workflowsListSuccess;

    @JsonCreator
    public GetWorkflowsListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WorkflowsListSuccess> workflowsListSuccess) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(workflowsListSuccess, "workflowsListSuccess");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.workflowsListSuccess = workflowsListSuccess;
    }

    public GetWorkflowsListResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WorkflowsListSuccess> workflowsListSuccess() {
        return this.workflowsListSuccess;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public GetWorkflowsListResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public GetWorkflowsListResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public GetWorkflowsListResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public GetWorkflowsListResponse withWorkflowsListSuccess(WorkflowsListSuccess workflowsListSuccess) {
        Utils.checkNotNull(workflowsListSuccess, "workflowsListSuccess");
        this.workflowsListSuccess = Optional.ofNullable(workflowsListSuccess);
        return this;
    }

    public GetWorkflowsListResponse withWorkflowsListSuccess(Optional<? extends WorkflowsListSuccess> workflowsListSuccess) {
        Utils.checkNotNull(workflowsListSuccess, "workflowsListSuccess");
        this.workflowsListSuccess = workflowsListSuccess;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWorkflowsListResponse other = (GetWorkflowsListResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.workflowsListSuccess, other.workflowsListSuccess);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.workflowsListSuccess);
    }

    public String toString() {
        return Utils.toString(GetWorkflowsListResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "workflowsListSuccess", this.workflowsListSuccess);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WorkflowsListSuccess> workflowsListSuccess = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder workflowsListSuccess(WorkflowsListSuccess workflowsListSuccess) {
            Utils.checkNotNull(workflowsListSuccess, "workflowsListSuccess");
            this.workflowsListSuccess = Optional.ofNullable(workflowsListSuccess);
            return this;
        }

        public Builder workflowsListSuccess(Optional<? extends WorkflowsListSuccess> workflowsListSuccess) {
            Utils.checkNotNull(workflowsListSuccess, "workflowsListSuccess");
            this.workflowsListSuccess = workflowsListSuccess;
            return this;
        }

        public GetWorkflowsListResponse build() {
            return new GetWorkflowsListResponse(this.contentType, this.statusCode, this.rawResponse, this.workflowsListSuccess);
        }
    }
}

