/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.utils;

import com.docusign.iam.sdk.utils.EventStreamReader;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EventStream<T>
implements AutoCloseable {
    private final EventStreamReader reader;
    private final TypeReference<T> typeReference;
    private final ObjectMapper mapper;
    private final Optional<String> terminalMessage;

    public EventStream(InputStream in, TypeReference<T> typeReference, ObjectMapper mapper, Optional<String> terminalMessage) {
        this.reader = new EventStreamReader(in);
        this.typeReference = typeReference;
        this.mapper = mapper;
        this.terminalMessage = terminalMessage;
    }

    public Optional<T> next() throws IOException {
        return this.reader.readMessage().filter(x -> !this.terminalMessage.isPresent() || !this.terminalMessage.get().equals(x.data())).map(x -> Utils.asType(x, this.mapper, this.typeReference));
    }

    public List<T> toList() {
        try {
            List list = this.stream().collect(Collectors.toList());
            return list;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){
            Optional<T> next = null;

            @Override
            public T next() {
                this.load();
                if (!this.next.isPresent()) {
                    throw new NoSuchElementException();
                }
                Object v = this.next.get();
                this.next = null;
                return v;
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this.next.isPresent();
            }

            private void load() {
                if (this.next == null) {
                    try {
                        this.next = EventStream.this.next();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }, 16), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.reader.close();
    }
}

