/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.utils;

import com.docusign.iam.sdk.models.errors.AuthException;
import com.docusign.iam.sdk.utils.HTTPClient;
import com.docusign.iam.sdk.utils.RequestBody;
import com.docusign.iam.sdk.utils.Utils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SessionManager<T extends HasSessionKey> {
    public static final int REFRESH_BEFORE_EXPIRY_SECONDS = 60;
    private final Map<String, Session<T>> sessions = new HashMap<String, Session<T>>();

    public Session<T> getSession(T credentials, Optional<List<String>> scopes, Function<List<String>, Session<T>> tokenProvider) {
        Session<T> session;
        String sessionKey = credentials.sessionKey();
        Optional<Session<T>> currentSession = Optional.ofNullable(this.sessions.get(sessionKey));
        if (SessionManager.shouldCreateNewSession(currentSession, scopes)) {
            List<String> accumulatedScopes = SessionManager.accumulateScopes(scopes, currentSession);
            session = tokenProvider.apply(accumulatedScopes);
            this.sessions.put(sessionKey, session);
        } else {
            session = currentSession.get();
        }
        return session;
    }

    public static <T extends HasSessionKey> boolean shouldCreateNewSession(Optional<Session<T>> currentSession, Optional<List<String>> oauthScopes) {
        return !currentSession.isPresent() || !SessionManager.hasRequiredScopes(currentSession.get().scopes, oauthScopes) || SessionManager.hasTokenExpired(currentSession.get().expiresAt, OffsetDateTime.now());
    }

    private static <T extends HasSessionKey> List<String> accumulateScopes(Optional<List<String>> requiredScopes, Optional<Session<T>> session) {
        if (session.isPresent()) {
            ArrayList<String> scopes = new ArrayList<String>(requiredScopes.orElse(Collections.emptyList()));
            scopes.addAll(session.get().scopes);
            return scopes.stream().distinct().collect(Collectors.toList());
        }
        return requiredScopes.orElse(Collections.emptyList());
    }

    public static boolean hasTokenExpired(Optional<OffsetDateTime> expiresAt, OffsetDateTime now) {
        return expiresAt.isEmpty() || now.plusSeconds(60L).isAfter(expiresAt.get());
    }

    public static boolean hasRequiredScopes(List<String> sessionScopes, Optional<List<String>> requiredScopes) {
        return sessionScopes.containsAll(requiredScopes.orElse(Collections.emptyList()));
    }

    public void remove(String sessionKey) {
        this.sessions.remove(sessionKey);
    }

    public static <T extends HasSessionKey> Session<T> requestOAuth2Token(HTTPClient client, T credentials, List<String> scopes, Map<String, String> body, Map<String, String> headers, URI tokenUri) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(tokenUri).header("Content-Type", "application/x-www-form-urlencoded").POST(RequestBody.serializeFormData(body).body());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.header(header.getKey(), header.getValue());
            }
            HttpRequest request = requestBuilder.build();
            HttpResponse<InputStream> response = client.send(request);
            if (response.statusCode() != 200) {
                String responseBody = Utils.toUtf8AndClose(response.body());
                throw new AuthException(response.statusCode(), "Unexpected status code " + response.statusCode() + ": " + responseBody);
            }
            TokenResponse t = (TokenResponse)Utils.mapper().readValue(response.body(), TokenResponse.class);
            if (!t.tokenType.orElse("").equals("Bearer")) {
                throw new AuthException("Expected 'Bearer' token type but was '" + t.tokenType.orElse("") + "'");
            }
            Optional<OffsetDateTime> expiresAt = t.expiresInSeconds.map(x -> OffsetDateTime.now().plus((long)x, ChronoUnit.SECONDS));
            return new Session<T>(credentials, t.accessToken, scopes, expiresAt);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static final class TokenResponse {
        @JsonProperty(value="access_token")
        Optional<String> accessToken;
        @JsonProperty(value="token_type")
        Optional<String> tokenType;
        @JsonProperty(value="expires_in")
        Optional<Long> expiresInSeconds;

        TokenResponse() {
        }
    }

    public static final class Session<T> {
        private final T credentials;
        private final Optional<String> token;
        private final List<String> scopes;
        private final Optional<OffsetDateTime> expiresAt;

        public Session(T credentials, Optional<String> token, List<String> scopes, Optional<OffsetDateTime> expiresAt) {
            this.credentials = credentials;
            this.token = token;
            this.scopes = scopes;
            this.expiresAt = expiresAt;
        }

        public T credentials() {
            return this.credentials;
        }

        public Optional<String> token() {
            return this.token;
        }

        public List<String> scopes() {
            return this.scopes;
        }

        public Optional<OffsetDateTime> expiresAt() {
            return this.expiresAt;
        }
    }

    public static interface HasSessionKey {
        public String sessionKey();
    }
}

