/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.iam.sdk.utils.auth;

import com.docusign.iam.sdk.models.components.AuthScope;
import com.docusign.iam.sdk.models.components.OAuthBasePath;
import com.docusign.iam.sdk.utils.auth.PrivateKeyHelper;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class JwtAssertionHelper {
    public static String generateJwt(String privateKey, String clientId, String userId, OAuthBasePath oauthBasePath, List<AuthScope> scopes) throws Exception {
        String basePath = oauthBasePath.getUrl();
        String scopesAsString = null;
        scopesAsString = scopes == null || scopes.isEmpty() ? AuthScope.getAllScopes().stream().map(AuthScope::getValue).collect(Collectors.joining(" ")) : scopes.stream().map(AuthScope::getValue).collect(Collectors.joining(" "));
        Instant now = Instant.now();
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(clientId).subject(userId).audience(basePath).issueTime(Date.from(now)).expirationTime(Date.from(now.plusSeconds(3600L))).notBeforeTime(Date.from(now)).claim("scope", (Object)scopesAsString).build();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).build();
        SignedJWT signedJWT = new SignedJWT(header, claims);
        signedJWT.sign((JWSSigner)new RSASSASigner((PrivateKey)PrivateKeyHelper.parsePrivateKey(privateKey)));
        return signedJWT.serialize();
    }

    public static String generateJwt(String privateKey, String clientId, String userId, List<AuthScope> scopes) throws Exception {
        return JwtAssertionHelper.generateJwt(privateKey, clientId, userId, OAuthBasePath.DEMO, scopes);
    }
}

