/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifInteropDirectory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.exif.makernotes.CanonMakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.CasioType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KodakMakernoteDirectory;
import com.drew.metadata.exif.makernotes.KyoceraMakernoteDirectory;
import com.drew.metadata.exif.makernotes.LeicaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import com.drew.metadata.exif.makernotes.OlympusMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import com.drew.metadata.exif.makernotes.PentaxMakernoteDirectory;
import com.drew.metadata.exif.makernotes.RicohMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SanyoMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType1MakernoteDirectory;
import com.drew.metadata.exif.makernotes.SonyType6MakernoteDirectory;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.tiff.DirectoryTiffHandler;
import java.io.IOException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifTiffHandler
extends DirectoryTiffHandler {
    private final boolean _storeThumbnailBytes;

    public ExifTiffHandler(@NotNull Metadata metadata, boolean storeThumbnailBytes) {
        super(metadata, ExifIFD0Directory.class);
        this._storeThumbnailBytes = storeThumbnailBytes;
    }

    @Override
    public void setTiffMarker(int marker) throws TiffProcessingException {
        int standardTiffMarker = 42;
        int olympusRawTiffMarker = 20306;
        int olympusRawTiffMarker2 = 21330;
        int panasonicRawTiffMarker = 85;
        if (marker != 42 && marker != 20306 && marker != 21330 && marker != 85) {
            throw new TiffProcessingException("Unexpected TIFF marker: 0x" + Integer.toHexString(marker));
        }
    }

    @Override
    public boolean isTagIfdPointer(int tagType) {
        if (tagType == 34665 && this._currentDirectory instanceof ExifIFD0Directory) {
            this.pushDirectory(ExifSubIFDDirectory.class);
            return true;
        }
        if (tagType == 34853 && this._currentDirectory instanceof ExifIFD0Directory) {
            this.pushDirectory(GpsDirectory.class);
            return true;
        }
        if (tagType == 40965 && this._currentDirectory instanceof ExifSubIFDDirectory) {
            this.pushDirectory(ExifInteropDirectory.class);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFollowerIfd() {
        if (this._currentDirectory instanceof ExifIFD0Directory) {
            this.pushDirectory(ExifThumbnailDirectory.class);
            return true;
        }
        return this._currentDirectory instanceof ExifThumbnailDirectory;
    }

    @Override
    public boolean customProcessTag(int tagOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull RandomAccessReader reader, int tagId, int byteCount) throws IOException {
        if (tagId == 37500 && this._currentDirectory instanceof ExifSubIFDDirectory) {
            return this.processMakernote(tagOffset, processedIfdOffsets, tiffHeaderOffset, reader);
        }
        if (tagId == 33723 && this._currentDirectory instanceof ExifIFD0Directory) {
            if (reader.getInt8(tagOffset) == 28) {
                byte[] iptcBytes = reader.getBytes(tagOffset, byteCount);
                new IptcReader().extract(new SequentialByteArrayReader(iptcBytes), this._metadata, iptcBytes.length);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void completed(@NotNull RandomAccessReader reader, int tiffHeaderOffset) {
        ExifThumbnailDirectory thumbnailDirectory;
        if (this._storeThumbnailBytes && (thumbnailDirectory = this._metadata.getFirstDirectoryOfType(ExifThumbnailDirectory.class)) != null && thumbnailDirectory.containsTag(259)) {
            Integer offset = thumbnailDirectory.getInteger(513);
            Integer length = thumbnailDirectory.getInteger(514);
            if (offset != null && length != null) {
                try {
                    byte[] thumbnailData = reader.getBytes(tiffHeaderOffset + offset, length);
                    thumbnailDirectory.setThumbnailData(thumbnailData);
                }
                catch (IOException ex) {
                    thumbnailDirectory.addError("Invalid thumbnail data specification: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processMakernote(int makernoteOffset, @NotNull Set<Integer> processedIfdOffsets, int tiffHeaderOffset, @NotNull RandomAccessReader reader) throws IOException {
        ExifIFD0Directory ifd0Directory = this._metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        if (ifd0Directory == null) {
            return false;
        }
        String cameraMake = ifd0Directory.getString(271);
        String firstTwoChars = reader.getString(makernoteOffset, 2);
        String firstThreeChars = reader.getString(makernoteOffset, 3);
        String firstFourChars = reader.getString(makernoteOffset, 4);
        String firstFiveChars = reader.getString(makernoteOffset, 5);
        String firstSixChars = reader.getString(makernoteOffset, 6);
        String firstSevenChars = reader.getString(makernoteOffset, 7);
        String firstEightChars = reader.getString(makernoteOffset, 8);
        String firstTwelveChars = reader.getString(makernoteOffset, 12);
        boolean byteOrderBefore = reader.isMotorolaByteOrder();
        if ("OLYMP".equals(firstFiveChars) || "EPSON".equals(firstFiveChars) || "AGFA".equals(firstFourChars)) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("MINOLTA")) {
            this.pushDirectory(OlympusMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.trim().toUpperCase().startsWith("NIKON")) {
            if ("Nikon".equals(firstFiveChars)) {
                switch (reader.getUInt8(makernoteOffset + 6)) {
                    case 1: {
                        this.pushDirectory(NikonType1MakernoteDirectory.class);
                        TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
                        break;
                    }
                    case 2: {
                        this.pushDirectory(NikonType2MakernoteDirectory.class);
                        TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 18, makernoteOffset + 10);
                        break;
                    }
                    default: {
                        ifd0Directory.addError("Unsupported Nikon makernote data ignored.");
                        break;
                    }
                }
            } else {
                this.pushDirectory(NikonType2MakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
            }
        } else if ("SONY CAM".equals(firstEightChars) || "SONY DSC".equals(firstEightChars)) {
            this.pushDirectory(SonyType1MakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset);
        } else if ("SEMC MS\u0000\u0000\u0000\u0000\u0000".equals(firstTwelveChars)) {
            reader.setMotorolaByteOrder(true);
            this.pushDirectory(SonyType6MakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 20, tiffHeaderOffset);
        } else if ("SIGMA\u0000\u0000\u0000".equals(firstEightChars) || "FOVEON\u0000\u0000".equals(firstEightChars)) {
            this.pushDirectory(SigmaMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 10, tiffHeaderOffset);
        } else if ("KDK".equals(firstThreeChars)) {
            reader.setMotorolaByteOrder(firstSevenChars.equals("KDK INFO"));
            KodakMakernoteDirectory directory = new KodakMakernoteDirectory();
            this._metadata.addDirectory(directory);
            ExifTiffHandler.processKodakMakernote(directory, makernoteOffset, reader);
        } else if ("Canon".equalsIgnoreCase(cameraMake)) {
            this.pushDirectory(CanonMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
        } else if (cameraMake != null && cameraMake.toUpperCase().startsWith("CASIO")) {
            if ("QVC\u0000\u0000\u0000".equals(firstSixChars)) {
                this.pushDirectory(CasioType2MakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 6, tiffHeaderOffset);
            } else {
                this.pushDirectory(CasioType1MakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset, tiffHeaderOffset);
            }
        } else if ("FUJIFILM".equals(firstEightChars) || "Fujifilm".equalsIgnoreCase(cameraMake)) {
            reader.setMotorolaByteOrder(false);
            int ifdStart = makernoteOffset + reader.getInt32(makernoteOffset + 8);
            this.pushDirectory(FujifilmMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, ifdStart, makernoteOffset);
        } else if ("KYOCERA".equals(firstSevenChars)) {
            this.pushDirectory(KyoceraMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 22, tiffHeaderOffset);
        } else if ("LEICA".equals(firstFiveChars)) {
            reader.setMotorolaByteOrder(false);
            if ("Leica Camera AG".equals(cameraMake)) {
                this.pushDirectory(LeicaMakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
            } else {
                if (!"LEICA".equals(cameraMake)) return false;
                this.pushDirectory(PanasonicMakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, tiffHeaderOffset);
            }
        } else if ("Panasonic\u0000\u0000\u0000".equals(reader.getString(makernoteOffset, 12))) {
            this.pushDirectory(PanasonicMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 12, tiffHeaderOffset);
        } else if ("AOC\u0000".equals(firstFourChars)) {
            this.pushDirectory(CasioType2MakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 6, makernoteOffset);
        } else if (cameraMake != null && (cameraMake.toUpperCase().startsWith("PENTAX") || cameraMake.toUpperCase().startsWith("ASAHI"))) {
            this.pushDirectory(PentaxMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset, makernoteOffset);
        } else if ("SANYO\u0000\u0001\u0000".equals(firstEightChars)) {
            this.pushDirectory(SanyoMakernoteDirectory.class);
            TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, makernoteOffset);
        } else {
            if (cameraMake == null || !cameraMake.toLowerCase().startsWith("ricoh")) return false;
            if (firstTwoChars.equals("Rv") || firstThreeChars.equals("Rev")) {
                return false;
            }
            if (firstFiveChars.equalsIgnoreCase("Ricoh")) {
                reader.setMotorolaByteOrder(true);
                this.pushDirectory(RicohMakernoteDirectory.class);
                TiffReader.processIfd(this, reader, processedIfdOffsets, makernoteOffset + 8, makernoteOffset);
            }
        }
        reader.setMotorolaByteOrder(byteOrderBefore);
        return true;
    }

    private static void processKodakMakernote(@NotNull KodakMakernoteDirectory directory, int tagValueOffset, @NotNull RandomAccessReader reader) {
        int dataOffset = tagValueOffset + 8;
        try {
            directory.setString(0, reader.getString(dataOffset, 8));
            directory.setInt(9, reader.getUInt8(dataOffset + 9));
            directory.setInt(10, reader.getUInt8(dataOffset + 10));
            directory.setInt(12, reader.getUInt16(dataOffset + 12));
            directory.setInt(14, reader.getUInt16(dataOffset + 14));
            directory.setInt(16, reader.getUInt16(dataOffset + 16));
            directory.setByteArray(18, reader.getBytes(dataOffset + 18, 2));
            directory.setByteArray(20, reader.getBytes(dataOffset + 20, 4));
            directory.setInt(24, reader.getUInt16(dataOffset + 24));
            directory.setInt(27, reader.getUInt8(dataOffset + 27));
            directory.setInt(28, reader.getUInt8(dataOffset + 28));
            directory.setInt(29, reader.getUInt8(dataOffset + 29));
            directory.setInt(30, reader.getUInt16(dataOffset + 30));
            directory.setLong(32, reader.getUInt32(dataOffset + 32));
            directory.setInt(36, reader.getInt16(dataOffset + 36));
            directory.setInt(56, reader.getUInt8(dataOffset + 56));
            directory.setInt(64, reader.getUInt8(dataOffset + 64));
            directory.setInt(92, reader.getUInt8(dataOffset + 92));
            directory.setInt(93, reader.getUInt8(dataOffset + 93));
            directory.setInt(94, reader.getUInt16(dataOffset + 94));
            directory.setInt(96, reader.getUInt16(dataOffset + 96));
            directory.setInt(98, reader.getUInt16(dataOffset + 98));
            directory.setInt(100, reader.getUInt16(dataOffset + 100));
            directory.setInt(102, reader.getUInt16(dataOffset + 102));
            directory.setInt(104, reader.getUInt16(dataOffset + 104));
            directory.setInt(107, reader.getInt8(dataOffset + 107));
        }
        catch (IOException ex) {
            directory.addError("Error processing Kodak makernote data: " + ex.getMessage());
        }
    }
}

