/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.http.client.protocol;

import gigahorse.shaded.apache.org.apache.http.Header;
import gigahorse.shaded.apache.org.apache.http.HeaderElement;
import gigahorse.shaded.apache.org.apache.http.HttpEntity;
import gigahorse.shaded.apache.org.apache.http.HttpException;
import gigahorse.shaded.apache.org.apache.http.HttpResponse;
import gigahorse.shaded.apache.org.apache.http.HttpResponseInterceptor;
import gigahorse.shaded.apache.org.apache.http.annotation.Contract;
import gigahorse.shaded.apache.org.apache.http.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.http.client.config.RequestConfig;
import gigahorse.shaded.apache.org.apache.http.client.entity.DecompressingEntity;
import gigahorse.shaded.apache.org.apache.http.client.entity.DeflateInputStreamFactory;
import gigahorse.shaded.apache.org.apache.http.client.entity.GZIPInputStreamFactory;
import gigahorse.shaded.apache.org.apache.http.client.entity.InputStreamFactory;
import gigahorse.shaded.apache.org.apache.http.client.protocol.HttpClientContext;
import gigahorse.shaded.apache.org.apache.http.config.Lookup;
import gigahorse.shaded.apache.org.apache.http.config.RegistryBuilder;
import gigahorse.shaded.apache.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = ignoreUnknown;
    }

    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, ignoreUnknown);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this(decoderRegistry, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

