/*
 * Decompiled with CFR 0.152.
 */
package gigahorse.shaded.apache.org.apache.hc.core5.http.protocol;

import gigahorse.shaded.apache.org.apache.hc.core5.annotation.Contract;
import gigahorse.shaded.apache.org.apache.hc.core5.annotation.ThreadingBehavior;
import gigahorse.shaded.apache.org.apache.hc.core5.http.EntityDetails;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpException;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpRequest;
import gigahorse.shaded.apache.org.apache.hc.core5.http.HttpRequestInterceptor;
import gigahorse.shaded.apache.org.apache.hc.core5.http.Method;
import gigahorse.shaded.apache.org.apache.hc.core5.http.protocol.HttpContext;
import gigahorse.shaded.apache.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestConnControl();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            if (request.containsHeader("Upgrade")) {
                request.addHeader("Connection", "upgrade");
            } else {
                request.addHeader("Connection", "keep-alive");
            }
        }
    }
}

