/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api;

import com.emc.atmos.api.BufferSegment;
import com.emc.atmos.api.ChecksumAlgorithm;
import com.emc.atmos.api.ChecksumValue;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RunningChecksum
extends ChecksumValue {
    private ChecksumAlgorithm algorithm;
    private long offset;
    private MessageDigest digest;

    public RunningChecksum(ChecksumAlgorithm algorithm) throws NoSuchAlgorithmException {
        this.algorithm = algorithm;
        this.offset = 0L;
        this.digest = MessageDigest.getInstance(algorithm.getDigestName());
    }

    public void update(byte[] buffer, int offset, int length) {
        this.digest.update(buffer, offset, length);
        this.offset += (long)length;
    }

    public void update(BufferSegment segment) {
        this.update(segment.getBuffer(), segment.getOffset(), segment.getSize());
    }

    @Override
    public ChecksumAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public String getValue() {
        MessageDigest tmpDigest;
        try {
            tmpDigest = (MessageDigest)this.digest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone failed", e);
        }
        byte[] currDigest = tmpDigest.digest();
        BigInteger bigInt = new BigInteger(1, currDigest);
        return String.format("%0" + (currDigest.length << 1) + "x", bigInt);
    }
}

