/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.api.ChecksumValueImpl;
import com.emc.atmos.api.ChecksummedInputStream;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumFilter
extends ClientFilter {
    private static final Logger l4j = LoggerFactory.getLogger(ChecksumFilter.class);

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        try {
            ClientResponse response = this.getNext().handle(request);
            String checksumHeader = (String)response.getHeaders().getFirst((Object)"x-emc-wschecksum");
            Object rangeHeader = request.getHeaders().getFirst((Object)"Range");
            if (checksumHeader != null && rangeHeader == null && "GET".equals(request.getMethod()) && response.getLength() > 0) {
                l4j.debug("wschecksum detected (" + checksumHeader + "); wrapping entity stream");
                ChecksumValueImpl checksum = new ChecksumValueImpl(checksumHeader);
                response.setEntityInputStream((InputStream)new ChecksummedInputStream(response.getEntityInputStream(), checksum));
            }
            return response;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

