/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.mgmt;

import com.emc.atmos.mgmt.AbstractMgmtConfig;
import com.sun.jersey.core.header.OutBoundHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TenantMgmtConfig
extends AbstractMgmtConfig {
    private String tenant;

    public TenantMgmtConfig(String tenant, String username, String password, URI ... endpoints) {
        super(username, password, endpoints);
        this.tenant = tenant;
    }

    @Override
    public Map<String, List<Object>> getRestAuthenticationHeaders() {
        OutBoundHeaders authHeaders = new OutBoundHeaders();
        authHeaders.putSingle("x-atmos-tenantadmin", (Object)this.getUsername());
        authHeaders.putSingle("x-atmos-tenantadminpassword", (Object)this.getPassword());
        authHeaders.putSingle("x-atmos-authType", (Object)"password");
        return authHeaders;
    }

    @Override
    public String getPoxLoginPath() {
        return "/user/verify";
    }

    @Override
    public Map<String, String> getPoxLoginParams() {
        HashMap<String, String> loginParams = new HashMap<String, String>();
        loginParams.put("tenant_name", this.getTenant());
        loginParams.put("username", this.getUsername());
        loginParams.put("password", this.getPassword());
        return loginParams;
    }

    public String getTenant() {
        return this.tenant;
    }
}

