/*
 * Decompiled with CFR 0.152.
 */
package com.emc.util;

import com.sun.jersey.core.header.HttpDateFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_DATE = "Date";
    public static final String HEADER_EXPECT = "Expect";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String HEADER_COOKIE = "Cookie";
    private static final String HEADER_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> headerFormat = new ThreadLocal();

    public static String headerFormat(Date date) {
        return HttpUtil.getHeaderFormat().format(date);
    }

    public static Date safeHeaderParse(String dateString) {
        if (dateString == null || dateString.trim().length() == 0) {
            return null;
        }
        try {
            return HttpDateFormat.readDate((String)dateString);
        }
        catch (ParseException e) {
            log.warn("Cannot parse date header: " + dateString, (Throwable)e);
            return null;
        }
    }

    public static String encodeUtf8(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    public static String decodeUtf8(String value) {
        try {
            return URLDecoder.decode(value.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding isn't supported on this system", e);
        }
    }

    private static DateFormat getHeaderFormat() {
        DateFormat format = headerFormat.get();
        if (format == null) {
            format = new SimpleDateFormat(HEADER_FORMAT, Locale.ENGLISH);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            headerFormat.set(format);
        }
        return format;
    }
}

