/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.network;

import com.emc.ecs.nfsclient.network.Connection;
import com.emc.ecs.nfsclient.network.RecordMarkingUtil;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.channels.NotYetConnectedException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIOHandler
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientIOHandler.class);
    private final ClientBootstrap _clientBootstrap;
    private final Connection _connection;

    public ClientIOHandler(ClientBootstrap bootstrap) {
        this._clientBootstrap = bootstrap;
        this._connection = (Connection)bootstrap.getOption("bourneLocalConn");
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this._clientBootstrap.getOption("remoteAddress");
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connected to: {}", (Object)this.getRemoteAddress());
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.closeConnection("Channel disconnected");
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.closeConnection("Channel closed");
    }

    private void closeConnection(String messageStart) {
        LOG.warn(messageStart + ": {}", (Object)this.getRemoteAddress());
        this._connection.close();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        byte[] rpcResponse = (byte[])e.getMessage();
        Xdr x = RecordMarkingUtil.removeRecordMarking(rpcResponse);
        int xid = x.getXid();
        this._connection.notifySender(xid, x);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof BindException) {
            return;
        }
        LOG.error("Exception on connection to " + this.getRemoteAddress(), e.getCause());
        if (!(cause instanceof NotYetConnectedException) || !this._connection.getConnectionState().equals((Object)Connection.State.CONNECTING)) {
            ctx.getChannel().close();
        }
    }
}

