/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.network;

import com.emc.ecs.nfsclient.network.Connection;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;

public class NetMgr {
    private static final NetMgr _instance = new NetMgr();
    private ConcurrentHashMap<InetSocketAddress, Connection> _connectionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<InetSocketAddress, Connection> _privilegedConnectionMap = new ConcurrentHashMap();
    private ChannelFactory _factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());

    public static NetMgr getInstance() {
        return _instance;
    }

    private NetMgr() {
    }

    public Xdr sendAndWait(String serverIP, int port, boolean usePrivilegedPort, Xdr xdrRequest, int timeout) throws RpcException {
        InetSocketAddress key;
        ConcurrentHashMap<InetSocketAddress, Connection> connectionMap = usePrivilegedPort ? this._privilegedConnectionMap : this._connectionMap;
        Connection connection = (Connection)connectionMap.get(key = InetSocketAddress.createUnresolved(serverIP, port));
        if (connection == null) {
            connection = new Connection(serverIP, port, usePrivilegedPort);
            connectionMap.put(key, connection);
            connection.connect();
        }
        return connection.sendAndWait(timeout, xdrRequest);
    }

    public void dropConnection(InetSocketAddress key) {
        this._connectionMap.remove(key);
        this._privilegedConnectionMap.remove(key);
    }

    public void shutdown() {
        for (Connection connection : this._connectionMap.values()) {
            connection.shutdown();
        }
        for (Connection connection : this._privilegedConnectionMap.values()) {
            connection.shutdown();
        }
        this._factory.releaseExternalResources();
    }

    public ChannelFactory getFactory() {
        return this._factory;
    }
}

