/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsTime;
import com.emc.ecs.nfsclient.nfs.NfsType;
import com.emc.ecs.nfsclient.rpc.Xdr;

public class NfsGetAttributes {
    private boolean _loaded = false;
    private NfsType _type;
    private long _mode;
    private long _nlink;
    private long _uid;
    private long _gid;
    private long _size;
    private long _used;
    private long[] _rdev = new long[]{0L, 0L};
    private long _fsid;
    private long _fileid;
    private NfsTime _atime;
    private NfsTime _mtime;
    private NfsTime _ctime;

    public void unmarshalling(Xdr xdr) {
        this._loaded = true;
        this._type = NfsType.fromValue((int)xdr.getUnsignedInt());
        this._mode = xdr.getUnsignedInt();
        this._nlink = xdr.getUnsignedInt();
        this._uid = xdr.getUnsignedInt();
        this._gid = xdr.getUnsignedInt();
        this._size = xdr.getLong();
        this._used = xdr.getLong();
        this._rdev[0] = xdr.getUnsignedInt();
        this._rdev[1] = xdr.getUnsignedInt();
        this._fsid = xdr.getLong();
        this._fileid = xdr.getLong();
        this._atime = new NfsTime();
        this._mtime = new NfsTime();
        this._ctime = new NfsTime();
        this._atime.unmarshalling(xdr);
        this._mtime.unmarshalling(xdr);
        this._ctime.unmarshalling(xdr);
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public NfsType getType() {
        return this._type;
    }

    public long getMode() {
        return this._mode;
    }

    public long getNlink() {
        return this._nlink;
    }

    public long getUid() {
        return this._uid;
    }

    public long getGid() {
        return this._gid;
    }

    public long getSize() {
        return this._size;
    }

    public long getUsed() {
        return this._used;
    }

    public long[] getRdev() {
        return this._rdev;
    }

    public long getFsid() {
        return this._fsid;
    }

    public long getFileid() {
        return this._fileid;
    }

    public NfsTime getAtime() {
        return this._atime;
    }

    public NfsTime getMtime() {
        return this._mtime;
    }

    public NfsTime getCtime() {
        return this._ctime;
    }

    public String toString() {
        return "NfsAttr{type=" + this._type + ", _mode=" + this._mode + ", _nlink=" + this._nlink + ", _uid=" + this._uid + ", _gid=" + this._gid + ", _size=" + this._size + ", _used=" + this._used + ", _specdata1=" + this._rdev[0] + ", _specdata2=" + this._rdev[1] + ", _fsid=" + this._fsid + ", _fileid=" + this._fileid + ", _atime=" + this._atime + ", _mtime=" + this._mtime + ", _ctime=" + this._ctime + '}';
    }
}

