/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsRequestBase;
import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.util.Arrays;

public class NfsRenameRequest
extends NfsRequestBase {
    private final String _name;
    private final byte[] _toFileHandle;
    private final String _toName;

    public NfsRenameRequest(byte[] fileHandle, String name, byte[] toFileHandle, String toName, Credential credential, int nfsVersion) throws FileNotFoundException {
        super(100003, nfsVersion, 14, credential, fileHandle);
        this._toFileHandle = NfsRenameRequest.cloneFileHandle(toFileHandle);
        this._name = NfsRenameRequest.trimFileName(name);
        this._toName = NfsRenameRequest.trimFileName(toName);
    }

    @Override
    public void marshalling(Xdr xdr) {
        super.marshalling(xdr);
        xdr.putString(this._name);
        xdr.putByteArray(this._toFileHandle);
        xdr.putString(this._toName);
    }

    public String toString() {
        return this.startToString("NfsRenameRequest").append(" name:").append(this._name).append(" toFileHandle:").append(Arrays.toString(this._toFileHandle)).append(" toName:").append(this._toName).toString();
    }
}

