/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsGetAttributes;
import com.emc.ecs.nfsclient.nfs.NfsStatus;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.RpcResponse;
import com.emc.ecs.nfsclient.rpc.Xdr;

public abstract class NfsResponseBase
extends RpcResponse {
    private NfsGetAttributes _attributes;
    private byte[] _fileHandle;
    private int _state;

    @Override
    public void unmarshalling(Xdr xdr) throws RpcException {
        super.unmarshalling(xdr);
        this._state = xdr.getInt();
    }

    public int getState() {
        return this._state;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("response");
        sb.append(" xid:");
        sb.append(String.valueOf(this._xid));
        sb.append(" state:");
        sb.append(String.valueOf(this._state));
        return sb.toString();
    }

    public final NfsGetAttributes getAttributes() {
        return this._attributes;
    }

    public final byte[] getFileHandle() {
        return this._fileHandle == null ? null : (byte[])this._fileHandle.clone();
    }

    public boolean stateIsOk() {
        return this._state == NfsStatus.NFS3_OK.getValue();
    }

    protected void unmarshallingAttributes(Xdr xdr) {
        this.unmarshallingAttributes(xdr, false);
    }

    protected void unmarshallingAttributes(Xdr xdr, boolean force) {
        this._attributes = NfsResponseBase.makeNfsGetAttributes(xdr, force);
    }

    protected void unmarshallingFileHandle(Xdr xdr) {
        this.unmarshallingFileHandle(xdr, false);
    }

    protected void unmarshallingFileHandle(Xdr xdr, boolean force) {
        if (force || xdr.getBoolean()) {
            this._fileHandle = xdr.getByteArray();
        }
    }

    protected static NfsGetAttributes makeNfsGetAttributes(Xdr xdr) {
        return NfsResponseBase.makeNfsGetAttributes(xdr, false);
    }

    protected static NfsGetAttributes makeNfsGetAttributes(Xdr xdr, boolean force) {
        NfsGetAttributes attributes = null;
        if (force || xdr.getBoolean()) {
            attributes = new NfsGetAttributes();
            attributes.unmarshalling(xdr);
        }
        return attributes;
    }
}

