/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsException;
import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.nfs.NfsStatus;
import com.emc.ecs.nfsclient.rpc.RejectStatus;
import com.emc.ecs.nfsclient.rpc.RpcRequest;
import com.emc.ecs.nfsclient.rpc.RpcResponseHandler;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class NfsResponseHandler<T extends NfsResponseBase>
extends RpcResponseHandler<T> {
    @Override
    public void checkResponse(RpcRequest request) throws IOException {
        if (((NfsResponseBase)this.getResponse()).getRejectStatus() == RejectStatus.AUTH_ERROR.getValue()) {
            request.setUsePrivilegedPort(true);
        }
        if (((NfsResponseBase)this.getResponse()).getState() != NfsStatus.NFS3_OK.getValue()) {
            int responseState = ((NfsResponseBase)this.getResponse()).getState();
            if (responseState == NfsStatus.NFS3ERR_NOENT.getValue()) {
                throw new FileNotFoundException(request.getErrorMessage());
            }
            NfsStatus status = NfsStatus.fromValue(responseState);
            throw new NfsException(status, request.getErrorMessage() + " error code:" + status.toString());
        }
    }
}

