/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.nfs;

import com.emc.ecs.nfsclient.nfs.NfsResponseBase;
import com.emc.ecs.nfsclient.nfs.NfsWccData;
import com.emc.ecs.nfsclient.rpc.RpcException;
import com.emc.ecs.nfsclient.rpc.Xdr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfsWriteResponse
extends NfsResponseBase {
    private static final Logger _log = LoggerFactory.getLogger(NfsWriteResponse.class);
    private int _committed;
    private int _count;
    private NfsWccData _fileWccData = new NfsWccData();
    private long _verf;

    public NfsWriteResponse(int nfsVersion) {
    }

    @Override
    public void unmarshalling(Xdr xdr) throws RpcException {
        super.unmarshalling(xdr);
        this._fileWccData = new NfsWccData(xdr);
        if (this.stateIsOk()) {
            this._count = xdr.getInt();
            this._committed = xdr.getInt();
            this._verf = xdr.getLong();
            _log.trace("committed {} verf {}", (Object)this._committed, (Object)this._verf);
        }
    }

    public int getCommitted() {
        return this._committed;
    }

    public int getCount() {
        return this._count;
    }

    public NfsWccData getFileWccData() {
        return this._fileWccData;
    }

    public long getVerf() {
        return this._verf;
    }
}

