/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.rpc;

import com.emc.ecs.nfsclient.rpc.CredentialBase;
import com.emc.ecs.nfsclient.rpc.RpcRequest;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

public class CredentialUnix
extends CredentialBase {
    private static final int AUTH_UNIX = 1;
    private final int _uid;
    private final int _gid;
    private final int[] _gids;
    private final String _host;
    private final int _maximumXdrBytes;

    public CredentialUnix(int uid, int gid, Set<Integer> gids) {
        this._uid = uid;
        this._gid = gid;
        if (gids == null) {
            gids = new HashSet<Integer>(0);
        }
        this._gids = new int[gids.size()];
        int index = 0;
        for (Integer id : gids) {
            this._gids[index] = id;
            ++index;
        }
        this._host = CredentialUnix.getHostname();
        this._maximumXdrBytes = 24 + 4 * this._gids.length + this._host.getBytes(RpcRequest.CHARSET).length;
    }

    public CredentialUnix() {
        this(0, 0, null);
    }

    @Override
    protected int getCredentialFlavor() {
        return 1;
    }

    @Override
    protected Xdr getCredential() {
        Xdr credentials = new Xdr(this._maximumXdrBytes);
        credentials.setOffset(0);
        credentials.putInt((int)(System.currentTimeMillis() / 1000L));
        credentials.putString(this._host);
        credentials.putInt(this._uid);
        credentials.putInt(this._gid);
        if (this._gids == null) {
            credentials.putInt(0);
        } else {
            credentials.putInt(this._gids.length);
            for (int i = 0; i < this._gids.length; ++i) {
                credentials.putInt(this._gids[i]);
            }
        }
        return credentials;
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }
}

