/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.rpc;

import com.emc.ecs.nfsclient.rpc.Credential;
import com.emc.ecs.nfsclient.rpc.Xdr;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public abstract class RpcRequest {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static AtomicInteger _nextXid = new AtomicInteger(RpcRequest.initializeXid());
    private final int _xid = RpcRequest.nextXid();
    private final int _direction = 0;
    private final int _rpcVersion = 2;
    private final int _serviceProgram;
    private final int _serviceVersion;
    private final int _serviceProcedure;
    private final Credential _credential;
    private boolean _usePrivilegedPort = false;

    public RpcRequest(int serviceProgram, int serviceVersion, int serviceProcedure, Credential credential) {
        this._serviceProgram = serviceProgram;
        this._serviceVersion = serviceVersion;
        this._serviceProcedure = serviceProcedure;
        this._credential = credential;
    }

    public void marshalling(Xdr xdr) {
        xdr.setXid(this._xid);
        xdr.putInt(this._xid);
        xdr.putInt(0);
        xdr.putInt(2);
        xdr.putInt(this._serviceProgram);
        xdr.putInt(this._serviceVersion);
        xdr.putInt(this._serviceProcedure);
        this._credential.marshalling(xdr);
    }

    public boolean isUsePrivilegedPort() {
        return this._usePrivilegedPort;
    }

    public void setUsePrivilegedPort(boolean usePrivilegedPort) {
        this._usePrivilegedPort = usePrivilegedPort;
    }

    private static int nextXid() {
        return _nextXid.getAndIncrement();
    }

    private static int initializeXid() {
        long cur = System.nanoTime();
        long seconds = cur / 1000000000L;
        long nano = cur % 1000000000L;
        int firstXid = (int)(seconds << 20 | nano >> 10);
        return firstXid;
    }

    protected StringBuilder startToString(String requestLabel) {
        StringBuilder stringBuilder = new StringBuilder(requestLabel);
        stringBuilder.append(" serviceVersion:").append(String.valueOf(this._serviceVersion));
        stringBuilder.append(" xid:").append(String.valueOf(this._xid));
        stringBuilder.append(" usePrivilegedPort:").append(String.valueOf(this._usePrivilegedPort));
        return stringBuilder;
    }

    public abstract String getErrorMessage();

    protected static final byte[] cloneFileHandle(byte[] fileHandle) throws FileNotFoundException {
        if (fileHandle == null) {
            throw new FileNotFoundException("The file handle is null, so this file does not exist.");
        }
        return (byte[])fileHandle.clone();
    }

    protected static final String trimFileName(String name) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("The file name cannot be blank.");
        }
        return name.trim();
    }
}

