/*
 * Decompiled with CFR 0.152.
 */
package com.emc.ecs.nfsclient.rpc;

import com.emc.ecs.nfsclient.rpc.RpcRequest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Xdr {
    private byte[] _buffer;
    private int _size;
    private int _offset;
    private int _xid;
    private List<ByteBuffer> _payloads;
    private int _payloadsSize;
    private static int BLOCK_SIZE = 4;
    private static final byte[] MAXIMUM_TERMINAL_PADDING = new byte[BLOCK_SIZE];

    public Xdr(int size) {
        this._buffer = new byte[size];
        this._size = size;
        this._offset = 0;
    }

    public Xdr(byte[] data) {
        this._buffer = (byte[])data.clone();
        this._size = data.length;
        this._offset = 0;
    }

    public void skip(int count) {
        int bytesToPad = Xdr.getBytesOfPadding(this._offset += count);
        this._offset += bytesToPad;
    }

    public byte[] getBuffer() {
        return (byte[])this._buffer.clone();
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    public int getInt() {
        return (this._buffer[this._offset++] & 0xFF) << 24 | (this._buffer[this._offset++] & 0xFF) << 16 | (this._buffer[this._offset++] & 0xFF) << 8 | this._buffer[this._offset++] & 0xFF;
    }

    public void putInt(int i) {
        this._buffer[this._offset++] = (byte)(i >>> 24);
        this._buffer[this._offset++] = (byte)(i >> 16);
        this._buffer[this._offset++] = (byte)(i >> 8);
        this._buffer[this._offset++] = (byte)i;
    }

    public long getUnsignedInt() {
        return (this._buffer[this._offset++] & 0xFF) << 24 | (this._buffer[this._offset++] & 0xFF) << 16 | (this._buffer[this._offset++] & 0xFF) << 8 | this._buffer[this._offset++] & 0xFF;
    }

    public void putUnsignedInt(long i) {
        this._buffer[this._offset++] = (byte)(i >>> 24 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 16);
        this._buffer[this._offset++] = (byte)(i >> 8);
        this._buffer[this._offset++] = (byte)i;
    }

    public long getLong() {
        return (long)(this._buffer[this._offset++] & 0xFF) << 56 | (long)(this._buffer[this._offset++] & 0xFF) << 48 | (long)(this._buffer[this._offset++] & 0xFF) << 40 | (long)(this._buffer[this._offset++] & 0xFF) << 32 | (long)(this._buffer[this._offset++] & 0xFF) << 24 | (long)(this._buffer[this._offset++] & 0xFF) << 16 | (long)(this._buffer[this._offset++] & 0xFF) << 8 | (long)(this._buffer[this._offset++] & 0xFF);
    }

    public void putLong(long i) {
        this._buffer[this._offset++] = (byte)(i >>> 56);
        this._buffer[this._offset++] = (byte)(i >> 48 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 40 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 32 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 24 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 16 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i >> 8 & 0xFFL);
        this._buffer[this._offset++] = (byte)(i & 0xFFL);
    }

    public boolean getBoolean() {
        return this.getInt() != 0;
    }

    public void putBoolean(boolean b) {
        this.putInt(b ? 1 : 0);
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public String getString() {
        int len = this.getInt();
        String s = new String(this._buffer, this._offset, len, RpcRequest.CHARSET);
        this.skip(len);
        return s;
    }

    public void putString(String s) {
        this.putByteArray(s.getBytes(RpcRequest.CHARSET));
    }

    public byte[] getByteArray() {
        int lengthToCopy = this.getInt();
        byte[] byteArray = lengthToCopy == 0 ? null : new byte[lengthToCopy];
        this.getBytes(lengthToCopy, byteArray, 0);
        return byteArray;
    }

    public void getBytes(int lengthToCopy, byte[] copyArray, int copyOffset) {
        if (lengthToCopy > 0) {
            System.arraycopy(this._buffer, this._offset, copyArray, copyOffset, lengthToCopy);
            this.skip(lengthToCopy);
        }
    }

    public void putByteArray(byte[] b) {
        this.putByteArray(b, 0, b.length);
    }

    public void putByteArray(byte[] b, int len) {
        this.putByteArray(b, 0, len);
    }

    public void putByteArray(byte[] b, int boff, int len) {
        this.putInt(len);
        this.putBytes(b, boff, len);
    }

    public void putByteArray(Xdr x) {
        this.putByteArray(x.getBuffer(), x.getOffset());
    }

    public void putBytes(byte[] b, int boff, int len) {
        System.arraycopy(b, boff, this._buffer, this._offset, len);
        this.skip(len);
    }

    public int getXid() {
        return this._xid;
    }

    public void setXid(int xid) {
        this._xid = xid;
    }

    public void putPayloads(List<ByteBuffer> payloads, int size) {
        this.putInt(size);
        if (this._payloads == null) {
            this._payloads = payloads;
        } else {
            this._payloads.addAll(payloads);
        }
        this._payloadsSize += size;
    }

    public List<ByteBuffer> getPayloads() {
        ByteBuffer terminalPadding = this.getTerminalPadding();
        if (terminalPadding != null) {
            ArrayList<ByteBuffer> paddingList = new ArrayList<ByteBuffer>(1);
            paddingList.add(terminalPadding);
            this.putPayloads(paddingList, terminalPadding.remaining());
        }
        return this._payloads;
    }

    ByteBuffer getTerminalPadding() {
        int bytesOfPadding = Xdr.getBytesOfPadding(this._offset + this._payloadsSize);
        if (bytesOfPadding == 0) {
            return null;
        }
        return ByteBuffer.wrap(MAXIMUM_TERMINAL_PADDING, 0, bytesOfPadding);
    }

    private static int getBytesOfPadding(int currentBytes) {
        int bytesOverLastXdrBlock = currentBytes % BLOCK_SIZE;
        return (BLOCK_SIZE - bytesOverLastXdrBlock) % BLOCK_SIZE;
    }
}

