/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.bean;

import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.adapter.ObjectIdAdapter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"objectId", "fileType", "filename", "systemMetadata", "userMetadata"})
public class DirectoryEntry {
    private ObjectId objectId;
    private FileType fileType;
    private String filename;
    private List<Metadata> systemMetadata;
    private List<Metadata> userMetadata;

    @XmlElement(name="ObjectID")
    @XmlJavaTypeAdapter(value=ObjectIdAdapter.class)
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @XmlElement(name="Filename")
    public String getFilename() {
        return this.filename;
    }

    @XmlElement(name="FileType")
    public FileType getFileType() {
        return this.fileType;
    }

    @XmlElementWrapper(name="SystemMetadataList")
    @XmlElement(name="Metadata")
    public List<Metadata> getSystemMetadata() {
        return this.systemMetadata;
    }

    @XmlTransient
    public Map<String, Metadata> getSystemMetadataMap() {
        if (this.systemMetadata == null) {
            return null;
        }
        TreeMap<String, Metadata> metadataMap = new TreeMap<String, Metadata>();
        for (Metadata metadata : this.systemMetadata) {
            metadataMap.put(metadata.getName(), metadata);
        }
        return metadataMap;
    }

    @XmlElementWrapper(name="UserMetadataList")
    @XmlElement(name="Metadata")
    public List<Metadata> getUserMetadata() {
        return this.userMetadata;
    }

    @XmlTransient
    public Map<String, Metadata> getUserMetadataMap() {
        if (this.userMetadata == null) {
            return null;
        }
        TreeMap<String, Metadata> metadataMap = new TreeMap<String, Metadata>();
        for (Metadata metadata : this.userMetadata) {
            metadataMap.put(metadata.getName(), metadata);
        }
        return metadataMap;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public void setSystemMetadata(List<Metadata> systemMetadata) {
        this.systemMetadata = systemMetadata;
    }

    public void setUserMetadata(List<Metadata> userMetadata) {
        this.userMetadata = userMetadata;
    }

    @XmlTransient
    public boolean isDirectory() {
        return FileType.directory == this.fileType;
    }

    public static enum FileType {
        directory,
        regular;

    }
}

