/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.encryption;

import com.emc.vipr.transform.TransformException;
import com.emc.vipr.transform.encryption.BasicEncryptionInputTransform;
import com.emc.vipr.transform.encryption.BasicEncryptionOutputTransform;
import com.emc.vipr.transform.encryption.BasicEncryptionTransformFactory;
import com.emc.vipr.transform.encryption.EncryptionTransformFactory;
import com.emc.vipr.transform.encryption.KeyStoreEncryptionFactory;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;

public class EncryptionConfig {
    private EncryptionTransformFactory<BasicEncryptionOutputTransform, BasicEncryptionInputTransform> factory;

    public EncryptionConfig(KeyStore keystore, char[] masterKeyPassword, String masterKeyAlias, Provider provider, int keySize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, TransformException {
        this.factory = provider == null ? new KeyStoreEncryptionFactory(keystore, masterKeyAlias, masterKeyPassword) : new KeyStoreEncryptionFactory(keystore, masterKeyAlias, masterKeyPassword, provider);
        this.factory.setEncryptionSettings("AES/CBC/PKCS5Padding", keySize, provider);
    }

    public EncryptionConfig(KeyPair masterEncryptionKey, Set<KeyPair> decryptionKeys, Provider provider, int keySize) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, TransformException {
        this.factory = provider == null ? new BasicEncryptionTransformFactory(masterEncryptionKey, decryptionKeys) : new BasicEncryptionTransformFactory(masterEncryptionKey, decryptionKeys, provider);
        this.factory.setEncryptionSettings("AES/CBC/PKCS5Padding", keySize, provider);
    }

    public EncryptionTransformFactory<BasicEncryptionOutputTransform, BasicEncryptionInputTransform> getFactory() {
        return this.factory;
    }
}

