/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey;

import com.emc.atmos.AtmosException;
import com.emc.atmos.api.Acl;
import com.emc.atmos.api.AtmosApi;
import com.emc.atmos.api.AtmosConfig;
import com.emc.atmos.api.BufferSegment;
import com.emc.atmos.api.ChecksumValue;
import com.emc.atmos.api.ChecksumValueImpl;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.ObjectKey;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.Range;
import com.emc.atmos.api.bean.ListVersionsResponse;
import com.emc.atmos.api.bean.Metadata;
import com.emc.atmos.api.bean.ObjectEntry;
import com.emc.atmos.api.bean.ObjectMetadata;
import com.emc.atmos.api.bean.ObjectVersion;
import com.emc.atmos.api.bean.Permission;
import com.emc.atmos.api.bean.ReadObjectResponse;
import com.emc.atmos.api.bean.Replica;
import com.emc.atmos.api.bean.ServiceInformation;
import com.emc.atmos.api.jersey.AtmosApiClient;
import com.emc.atmos.api.request.CreateObjectRequest;
import com.emc.atmos.api.request.ListDirectoryRequest;
import com.emc.atmos.api.request.ListObjectsRequest;
import com.emc.atmos.api.request.ListVersionsRequest;
import com.emc.atmos.api.request.UpdateObjectRequest;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.DirectoryEntry;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Grant;
import com.emc.esu.api.Grantee;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.ListOptions;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.MetadataTag;
import com.emc.esu.api.MetadataTags;
import com.emc.esu.api.ObjectExpiration;
import com.emc.esu.api.ObjectInfo;
import com.emc.esu.api.ObjectReplica;
import com.emc.esu.api.ObjectResult;
import com.emc.esu.api.ObjectRetention;
import com.emc.esu.api.Version;
import com.emc.esu.api.rest.AbstractEsuRestApi;
import com.emc.util.StreamUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.codec.binary.Base64;

public class EsuApiJerseyAdapter
extends AbstractEsuRestApi {
    private JAXBContext jaxbContext;
    private ThreadLocal<Marshaller> marshaller = new ThreadLocal();
    private AtmosApi adaptee;

    public EsuApiJerseyAdapter(AtmosConfig config) throws URISyntaxException, UnsupportedEncodingException, JAXBException {
        super(config.getEndpoints()[0].getHost(), config.getEndpoints()[0].getPort(), config.getTokenId(), new String(Base64.encodeBase64((byte[])config.getSecretKey()), "UTF-8"));
        this.adaptee = new AtmosApiClient(config);
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{com.emc.atmos.api.bean.ObjectInfo.class});
    }

    @Override
    public long calculateServerOffset() {
        return this.adaptee.calculateServerClockSkew();
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectFromStream(com.emc.esu.api.Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            CreateObjectRequest request = new CreateObjectRequest();
            ((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)request.acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(data)).contentLength(length)).contentType(mimeType);
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectFromStreamOnPath(com.emc.esu.api.ObjectPath path, com.emc.esu.api.Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            CreateObjectRequest request = new CreateObjectRequest();
            ((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)request.identifier(this.adaptIdentifier(path))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(data)).contentLength(length)).contentType(mimeType);
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectFromSegment(com.emc.esu.api.Acl acl, MetadataList metadata, com.emc.esu.api.BufferSegment data, String mimeType, Checksum checksum) {
        try {
            CreateObjectRequest request = new CreateObjectRequest();
            ((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)request.acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(this.adaptBuffer(data))).contentType(mimeType)).wsChecksum(this.adaptChecksum(checksum, data));
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectFromSegmentOnPath(com.emc.esu.api.ObjectPath path, com.emc.esu.api.Acl acl, MetadataList metadata, com.emc.esu.api.BufferSegment data, String mimeType, Checksum checksum) {
        try {
            CreateObjectRequest request = new CreateObjectRequest();
            ((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)((CreateObjectRequest)request.identifier(this.adaptIdentifier(path))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(this.adaptBuffer(data))).contentType(mimeType)).wsChecksum(this.adaptChecksum(checksum, data));
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void updateObjectFromStream(Identifier id, com.emc.esu.api.Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            UpdateObjectRequest request = new UpdateObjectRequest();
            ((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)request.identifier(this.adaptIdentifier(id))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).range(this.adaptExtent(extent)).content(data)).contentLength(length)).contentType(mimeType);
            this.adaptee.updateObject(request);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void updateObjectFromSegment(Identifier id, com.emc.esu.api.Acl acl, MetadataList metadata, Extent extent, com.emc.esu.api.BufferSegment data, String mimeType, Checksum checksum) {
        try {
            UpdateObjectRequest request = new UpdateObjectRequest();
            ((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)request.identifier(this.adaptIdentifier(id))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).range(this.adaptExtent(extent)).content(this.adaptBuffer(data))).contentType(mimeType)).wsChecksum(this.adaptChecksum(checksum, data));
            this.adaptee.updateObject(request);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void setUserMetadata(Identifier id, MetadataList metadata) {
        try {
            this.adaptee.setUserMetadata(this.adaptIdentifier(id), this.adaptMetadata(metadata));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void setAcl(Identifier id, com.emc.esu.api.Acl acl) {
        try {
            this.adaptee.setAcl(this.adaptIdentifier(id), this.adaptAcl(acl));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void deleteObject(Identifier id) {
        try {
            this.adaptee.delete(this.adaptIdentifier(id));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void deleteVersion(com.emc.esu.api.ObjectId id) {
        try {
            this.adaptee.deleteVersion((ObjectId)this.adaptIdentifier(id));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataList getUserMetadata(Identifier id, MetadataTags tags) {
        try {
            return this.adaptMetadata(this.adaptee.getUserMetadata(this.adaptIdentifier(id), this.adaptNames(tags)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(Identifier id, MetadataTags tags) {
        try {
            return this.adaptMetadata(this.adaptee.getSystemMetadata(this.adaptIdentifier(id), this.adaptNames(tags)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public byte[] readObject(Identifier id, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            return this.readObject(this.adaptIdentifier(id), extent, buffer, checksum);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public InputStream readObjectStream(Identifier id, Extent extent) {
        try {
            return this.adaptee.readObjectStream(this.adaptIdentifier(id), this.adaptExtent(extent)).getObject();
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.Acl getAcl(Identifier id) {
        try {
            return this.adaptAcl(this.adaptee.getAcl(this.adaptIdentifier(id)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void deleteUserMetadata(Identifier id, MetadataTags tags) {
        try {
            this.adaptee.deleteUserMetadata(this.adaptIdentifier(id), this.adaptNames(tags));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public List<Identifier> listVersions(Identifier id) {
        try {
            ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
            List<Version> versions = this.listVersions((com.emc.esu.api.ObjectId)id, null);
            for (Version version : versions) {
                identifiers.add(version.getId());
            }
            return identifiers;
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public List<Version> listVersions(com.emc.esu.api.ObjectId id, ListOptions options) {
        try {
            ListVersionsResponse response;
            ArrayList<Version> versions = new ArrayList<Version>();
            ListVersionsRequest request = new ListVersionsRequest();
            request.setObjectId((ObjectId)this.adaptIdentifier(id));
            if (options != null) {
                ((ListVersionsRequest)request.limit(options.getLimit())).token(options.getToken());
            }
            if ((response = this.adaptee.listVersions(request)).getVersions() != null) {
                for (ObjectVersion version : response.getVersions()) {
                    versions.add(this.adaptVersion(version));
                }
            }
            if (options != null) {
                options.setToken(request.getToken());
            }
            return versions;
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectId versionObject(Identifier id) {
        try {
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createVersion(this.adaptIdentifier(id)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public List<ObjectResult> listObjects(String tag, ListOptions options) {
        try {
            ArrayList<ObjectResult> results = new ArrayList<ObjectResult>();
            ListObjectsRequest request = new ListObjectsRequest().metadataName(tag);
            if (options != null) {
                request.limit(options.getLimit());
                ((ListObjectsRequest)request.token(options.getToken())).includeMetadata(options.isIncludeMetadata());
                if (options.getUserMetadata() != null) {
                    request.userMetadataNames(options.getUserMetadata().toArray(new String[options.getUserMetadata().size()]));
                }
                if (options.getSystemMetadata() != null) {
                    request.systemMetadataNames(options.getSystemMetadata().toArray(new String[options.getSystemMetadata().size()]));
                }
            }
            for (ObjectEntry entry : this.adaptee.listObjects(request).getEntries()) {
                results.add(this.adaptObjectEntry(entry));
            }
            if (options != null) {
                options.setToken(request.getToken());
            }
            return results;
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataTags getListableTags(MetadataTag tag) {
        try {
            return this.getListableTags(tag.getName());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataTags getListableTags(String tag) {
        try {
            return this.adaptTags(this.adaptee.listMetadata(tag));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataTags listUserMetadataTags(Identifier id) {
        try {
            return this.adaptTags(this.adaptee.getUserMetadataNames(this.adaptIdentifier(id)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public List<com.emc.esu.api.ObjectId> queryObjects(String xquery) {
        throw new UnsupportedOperationException("This implementation does not support object query");
    }

    @Override
    public List<DirectoryEntry> listDirectory(com.emc.esu.api.ObjectPath path, ListOptions options) {
        try {
            ArrayList<DirectoryEntry> entries = new ArrayList<DirectoryEntry>();
            ListDirectoryRequest request = new ListDirectoryRequest();
            request.path((ObjectPath)this.adaptIdentifier(path));
            if (options != null) {
                ((ListDirectoryRequest)((ListDirectoryRequest)request.limit(options.getLimit())).token(options.getToken())).includeMetadata(options.isIncludeMetadata());
                if (options.getUserMetadata() != null) {
                    request.userMetadataNames(options.getUserMetadata().toArray(new String[options.getUserMetadata().size()]));
                }
                if (options.getSystemMetadata() != null) {
                    request.systemMetadataNames(options.getSystemMetadata().toArray(new String[options.getSystemMetadata().size()]));
                }
            }
            for (com.emc.atmos.api.bean.DirectoryEntry entry : this.adaptee.listDirectory(request).getEntries()) {
                entries.add(this.adaptDirectoryEntry(entry, (ObjectPath)this.adaptIdentifier(path)));
            }
            if (options != null) {
                options.setToken(request.getToken());
            }
            return entries;
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectMetadata getAllMetadata(Identifier id) {
        try {
            return this.adaptObjectMetadata(this.adaptee.getObjectMetadata(this.adaptIdentifier(id)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void rename(com.emc.esu.api.ObjectPath source, com.emc.esu.api.ObjectPath destination, boolean force) {
        try {
            this.adaptee.move((ObjectPath)this.adaptIdentifier(source), (ObjectPath)this.adaptIdentifier(destination), force);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void restoreVersion(com.emc.esu.api.ObjectId id, com.emc.esu.api.ObjectId vId) {
        try {
            this.adaptee.restoreVersion((ObjectId)this.adaptIdentifier(id), (ObjectId)this.adaptIdentifier(vId));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ServiceInformation getServiceInformation() {
        try {
            return this.adaptServiceInformation(this.adaptee.getServiceInformation());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public ObjectInfo getObjectInfo(Identifier id) {
        try {
            return this.adaptObjectInfo(this.adaptee.getObjectInfo(this.adaptIdentifier(id)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not marshall result to XML", e);
        }
    }

    @Override
    public void hardLink(com.emc.esu.api.ObjectPath source, com.emc.esu.api.ObjectPath target) {
        throw new UnsupportedOperationException("This implementation does not support hard link");
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectWithKeyFromSegment(String keyPool, String key, com.emc.esu.api.Acl acl, MetadataList metadata, com.emc.esu.api.BufferSegment data, String mimeType, Checksum checksum) {
        try {
            CreateObjectRequest request = (CreateObjectRequest)new CreateObjectRequest().identifier(new ObjectKey(keyPool, key));
            ((CreateObjectRequest)((CreateObjectRequest)request.acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(this.adaptBuffer(data));
            ((CreateObjectRequest)request.contentType(mimeType)).wsChecksum(this.adaptChecksum(checksum, data));
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectId createObjectWithKeyFromStream(String keyPool, String key, com.emc.esu.api.Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            CreateObjectRequest request = (CreateObjectRequest)new CreateObjectRequest().identifier(new ObjectKey(keyPool, key));
            ((CreateObjectRequest)((CreateObjectRequest)request.acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).content(data);
            ((CreateObjectRequest)request.contentLength(length)).contentType(mimeType);
            return (com.emc.esu.api.ObjectId)this.adaptIdentifier(this.adaptee.createObject(request).getObjectId());
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void deleteObjectWithKey(String keyPool, String key) {
        try {
            this.adaptee.delete(new ObjectKey(keyPool, key));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public com.emc.esu.api.ObjectMetadata getAllMetadata(String keyPool, String key) {
        try {
            return this.adaptObjectMetadata(this.adaptee.getObjectMetadata(new ObjectKey(keyPool, key)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(String keyPool, String key, MetadataTags tags) {
        try {
            return this.adaptMetadata(this.adaptee.getSystemMetadata(new ObjectKey(keyPool, key), this.adaptNames(tags)));
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public byte[] readObjectWithKey(String keyPool, String key, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            return this.readObject(new ObjectKey(keyPool, key), extent, buffer, checksum);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public InputStream readObjectStreamWithKey(String keyPool, String key, Extent extent) {
        try {
            return this.adaptee.readObjectStream(new ObjectKey(keyPool, key), this.adaptExtent(extent)).getObject();
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void updateObjectWithKeyFromStream(String keyPool, String key, com.emc.esu.api.Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            UpdateObjectRequest request = new UpdateObjectRequest();
            ((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)request.identifier(new ObjectKey(keyPool, key))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).range(this.adaptExtent(extent)).content(data)).contentLength(length)).contentType(mimeType);
            this.adaptee.updateObject(request);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    @Override
    public void updateObjectWithKeyFromSegment(String keyPool, String key, com.emc.esu.api.Acl acl, MetadataList metadata, Extent extent, com.emc.esu.api.BufferSegment data, String mimeType, Checksum checksum) {
        try {
            UpdateObjectRequest request = new UpdateObjectRequest();
            ((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)((UpdateObjectRequest)request.identifier(new ObjectKey(keyPool, key))).acl(this.adaptAcl(acl))).userMetadata(this.adaptMetadata(metadata))).range(this.adaptExtent(extent)).content(this.adaptBuffer(data))).contentType(mimeType)).wsChecksum(this.adaptChecksum(checksum, data));
            this.adaptee.updateObject(request);
        }
        catch (AtmosException e) {
            throw this.adaptException(e);
        }
    }

    private byte[] readObject(ObjectIdentifier identifier, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            if (buffer != null && extent != null && extent.getSize() > (long)buffer.length) {
                throw new IllegalArgumentException("The buffer is smaller than the requested extent");
            }
            ReadObjectResponse<InputStream> response = this.adaptee.readObjectStream(identifier, this.adaptExtent(extent));
            long contentLength = response.getContentLength();
            if (buffer != null && contentLength > -1L) {
                if ((long)buffer.length < contentLength) {
                    throw new EsuException("The response buffer was not long enough to hold the response: " + buffer.length + "<" + contentLength);
                }
                int c = 0;
                InputStream in = response.getObject();
                while ((long)c < contentLength) {
                    int read = in.read(buffer, c, (int)contentLength - c);
                    if (read == -1) {
                        throw new EOFException("EOF reading response at position " + c + " size " + (contentLength - (long)c));
                    }
                    c += read;
                }
            } else {
                if (contentLength > Integer.MAX_VALUE) {
                    throw new EsuException("Object is too large to hold in a byte array");
                }
                buffer = StreamUtil.readAsBytes(response.getObject());
            }
            if (checksum != null && response.getWsChecksum() != null) {
                checksum.setExpectedValue(response.getWsChecksum().toString());
                if (contentLength > -1L) {
                    checksum.update(buffer, 0, (int)contentLength);
                } else {
                    checksum.update(buffer, 0, buffer.length);
                }
            }
            return buffer;
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
    }

    private ObjectIdentifier adaptIdentifier(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof com.emc.esu.api.ObjectId) {
            return new ObjectId(identifier.toString());
        }
        if (identifier instanceof com.emc.esu.api.ObjectPath) {
            return new ObjectPath(identifier.toString());
        }
        throw new RuntimeException("Unable to convert identifier " + identifier + " (" + identifier.getClass().getName() + ")");
    }

    private Identifier adaptIdentifier(ObjectIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier instanceof ObjectId) {
            return new com.emc.esu.api.ObjectId(identifier.toString());
        }
        if (identifier instanceof ObjectPath) {
            return new com.emc.esu.api.ObjectPath(identifier.toString());
        }
        throw new RuntimeException("Unable to convert identifier " + identifier + " (" + identifier.getClass().getName() + ")");
    }

    private Acl adaptAcl(com.emc.esu.api.Acl acl) {
        if (acl == null) {
            return null;
        }
        Acl newAcl = new Acl();
        for (Grant grant : acl) {
            switch (grant.getGrantee().getType()) {
                case GROUP: {
                    newAcl.addGroupGrant(grant.getGrantee().getName(), Permission.valueOf(grant.getPermission()));
                    break;
                }
                case USER: {
                    newAcl.addUserGrant(grant.getGrantee().getName(), Permission.valueOf(grant.getPermission()));
                }
            }
        }
        return newAcl;
    }

    private com.emc.esu.api.Acl adaptAcl(Acl acl) {
        if (acl == null) {
            return null;
        }
        com.emc.esu.api.Acl newAcl = new com.emc.esu.api.Acl();
        for (String name : acl.getGroupAcl().keySet()) {
            newAcl.addGrant(new Grant(new Grantee(name, Grantee.GRANT_TYPE.GROUP), acl.getGroupAcl().get(name).toString()));
        }
        for (String name : acl.getUserAcl().keySet()) {
            newAcl.addGrant(new Grant(new Grantee(name, Grantee.GRANT_TYPE.USER), acl.getUserAcl().get(name).toString()));
        }
        return newAcl;
    }

    private Metadata[] adaptMetadata(MetadataList metadataList) {
        if (metadataList == null) {
            return null;
        }
        ArrayList<Metadata> newMetadata = new ArrayList<Metadata>();
        for (com.emc.esu.api.Metadata metadata : metadataList) {
            newMetadata.add(new Metadata(metadata.getName(), metadata.getValue(), metadata.isListable()));
        }
        return newMetadata.toArray(new Metadata[newMetadata.size()]);
    }

    private MetadataList adaptMetadata(Map<String, Metadata> metadataMap) {
        if (metadataMap == null) {
            return null;
        }
        MetadataList metadataList = new MetadataList();
        for (Metadata oneMetadata : metadataMap.values()) {
            metadataList.addMetadata(new com.emc.esu.api.Metadata(oneMetadata.getName(), oneMetadata.getValue(), oneMetadata.isListable()));
        }
        return metadataList;
    }

    private String[] adaptNames(MetadataTags tags) {
        if (tags == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (MetadataTag tag : tags) {
            names.add(tag.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    private MetadataTags adaptTags(Set<String> names) {
        if (names == null) {
            return null;
        }
        MetadataTags newTags = new MetadataTags();
        for (String name : names) {
            newTags.addTag(new MetadataTag(name, false));
        }
        return newTags;
    }

    private MetadataTags adaptTags(Map<String, Boolean> tags) {
        if (tags == null) {
            return null;
        }
        MetadataTags newTags = new MetadataTags();
        for (String name : tags.keySet()) {
            newTags.addTag(new MetadataTag(name, tags.get(name)));
        }
        return newTags;
    }

    private Range adaptExtent(Extent extent) {
        if (extent == null) {
            return null;
        }
        return new Range(extent.getOffset(), extent.getOffset() + extent.getSize() - 1L);
    }

    private BufferSegment adaptBuffer(com.emc.esu.api.BufferSegment bufferSegment) {
        if (bufferSegment == null) {
            return null;
        }
        return new BufferSegment(bufferSegment.getBuffer(), bufferSegment.getOffset(), bufferSegment.getSize());
    }

    private ChecksumValue adaptChecksum(Checksum checksum, com.emc.esu.api.BufferSegment bufferSegment) {
        if (checksum == null) {
            return null;
        }
        checksum.update(bufferSegment.getBuffer(), bufferSegment.getOffset(), bufferSegment.getSize());
        return new ChecksumValueImpl(checksum.toString());
    }

    private Version adaptVersion(ObjectVersion version) {
        if (version == null) {
            return null;
        }
        return new Version((com.emc.esu.api.ObjectId)this.adaptIdentifier(version.getVersionId()), version.getVersionNumber(), version.getItime());
    }

    private ObjectResult adaptObjectEntry(ObjectEntry entry) {
        if (entry == null) {
            return null;
        }
        ObjectResult result = new ObjectResult();
        result.setId((com.emc.esu.api.ObjectId)this.adaptIdentifier(entry.getObjectId()));
        TreeMap<String, Metadata> allMetadata = new TreeMap<String, Metadata>();
        if (entry.getSystemMetadata() != null) {
            allMetadata.putAll(entry.getSystemMetadataMap());
        }
        if (entry.getUserMetadata() != null) {
            allMetadata.putAll(entry.getUserMetadataMap());
        }
        if (!allMetadata.isEmpty()) {
            result.setMetadata(this.adaptMetadata(allMetadata));
        }
        return result;
    }

    private DirectoryEntry adaptDirectoryEntry(com.emc.atmos.api.bean.DirectoryEntry entry, ObjectPath parentPath) {
        if (entry == null) {
            return null;
        }
        String path = parentPath.getPath() + entry.getFilename();
        if (entry.isDirectory()) {
            path = path + "/";
        }
        DirectoryEntry newEntry = new DirectoryEntry();
        newEntry.setId((com.emc.esu.api.ObjectId)this.adaptIdentifier(entry.getObjectId()));
        newEntry.setPath(new com.emc.esu.api.ObjectPath(path));
        newEntry.setType(entry.getFileType().toString());
        newEntry.setSystemMetadata(this.adaptMetadata(entry.getSystemMetadataMap()));
        newEntry.setUserMetadata(this.adaptMetadata(entry.getUserMetadataMap()));
        return newEntry;
    }

    private com.emc.esu.api.ObjectMetadata adaptObjectMetadata(ObjectMetadata objectMetadata) {
        if (objectMetadata == null) {
            return null;
        }
        com.emc.esu.api.ObjectMetadata newMetadata = new com.emc.esu.api.ObjectMetadata();
        newMetadata.setAcl(this.adaptAcl(objectMetadata.getAcl()));
        newMetadata.setMimeType(objectMetadata.getContentType());
        newMetadata.setMetadata(this.adaptMetadata(objectMetadata.getMetadata()));
        return newMetadata;
    }

    private ObjectInfo adaptObjectInfo(com.emc.atmos.api.bean.ObjectInfo objectInfo) throws JAXBException {
        if (objectInfo == null) {
            return null;
        }
        ObjectInfo newObjectInfo = new ObjectInfo();
        newObjectInfo.setObjectId((com.emc.esu.api.ObjectId)this.adaptIdentifier(objectInfo.getObjectId()));
        newObjectInfo.setSelection(objectInfo.getSelection());
        if (objectInfo.getExpiration() != null) {
            ObjectExpiration objectExpiration = new ObjectExpiration();
            objectExpiration.setEnabled(objectInfo.getExpiration().isEnabled());
            objectExpiration.setEndAt(objectInfo.getExpiration().getEndAt());
            newObjectInfo.setExpiration(objectExpiration);
        }
        if (objectInfo.getRetention() != null) {
            ObjectRetention objectRetention = new ObjectRetention();
            objectRetention.setEnabled(objectInfo.getRetention().isEnabled());
            objectRetention.setEndAt(objectInfo.getRetention().getEndAt());
            newObjectInfo.setRetention(objectRetention);
        }
        if (objectInfo.getReplicas() != null) {
            ArrayList<ObjectReplica> replicas = new ArrayList<ObjectReplica>();
            for (Replica replica : objectInfo.getReplicas()) {
                ObjectReplica newReplica = new ObjectReplica();
                newReplica.setId("" + replica.getId());
                newReplica.setCurrent(replica.isCurrent());
                newReplica.setLocation(replica.getLocation());
                newReplica.setReplicaType(replica.getType());
                newReplica.setStorageType(replica.getStorageType());
                replicas.add(newReplica);
            }
            newObjectInfo.setReplicas(replicas);
        }
        StringWriter xmlString = new StringWriter();
        this.getMarshaller().marshal((Object)objectInfo, (Writer)xmlString);
        newObjectInfo.setRawXml(xmlString.toString());
        return newObjectInfo;
    }

    private com.emc.esu.api.ServiceInformation adaptServiceInformation(ServiceInformation serviceInformation) {
        if (serviceInformation == null) {
            return null;
        }
        com.emc.esu.api.ServiceInformation newServiceInformation = new com.emc.esu.api.ServiceInformation();
        newServiceInformation.setAtmosVersion(serviceInformation.getAtmosVersion());
        newServiceInformation.setUnicodeMetadataSupported(serviceInformation.hasFeature(ServiceInformation.Feature.Utf8));
        for (ServiceInformation.Feature feature : serviceInformation.getFeatures()) {
            newServiceInformation.addFeature(feature.getHeaderName());
        }
        return newServiceInformation;
    }

    private EsuException adaptException(AtmosException e) {
        return new EsuException(e.getMessage(), e.getCause(), e.getHttpCode(), e.getErrorCode());
    }

    private Marshaller getMarshaller() throws JAXBException {
        Marshaller m = this.marshaller.get();
        if (m == null) {
            m = this.jaxbContext.createMarshaller();
            this.marshaller.set(m);
        }
        return m;
    }
}

