/*
 * Decompiled with CFR 0.152.
 */
package com.emc.atmos.api.jersey.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class MeasuredMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    protected MessageBodyWriter<T> wrapped;
    private IOException delayedIOException;
    private WebApplicationException delayedWebAppException;

    public MeasuredMessageBodyWriter(MessageBodyWriter<T> wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.wrapped.isWriteable(type, genericType, annotations, mediaType);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (this.delayedIOException != null) {
            throw this.delayedIOException;
        }
        if (this.delayedWebAppException != null) {
            throw this.delayedWebAppException;
        }
        entityStream.write(this.getBuffer(t, type, genericType, annotations, mediaType, httpHeaders));
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            return this.getBuffer(t, type, genericType, annotations, mediaType, null).length;
        }
        catch (IOException e) {
            this.delayedIOException = e;
        }
        catch (WebApplicationException e) {
            this.delayedWebAppException = e;
        }
        return -1L;
    }

    protected synchronized byte[] getBuffer(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.wrapped.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, (OutputStream)baos);
        return baos.toByteArray();
    }
}

