/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;
import org.concord.security.ccjce.cryptix.jce.provider.CryptixCrypto;

public class Checksum {
    private static final Logger l4j = Logger.getLogger(Checksum.class);
    private MessageDigest digest;
    private Algorithm alg;
    private long offset;
    private String expectedValue;

    public Checksum(Algorithm alg) throws NoSuchAlgorithmException {
        switch (alg) {
            case SHA0: {
                this.digest = MessageDigest.getInstance("SHA-0");
                break;
            }
            case SHA1: {
                this.digest = MessageDigest.getInstance("SHA-1");
                break;
            }
            case MD5: {
                this.digest = MessageDigest.getInstance("MD5");
            }
        }
        this.alg = alg;
        this.offset = 0L;
    }

    public String getAlgorithmName() {
        switch (this.alg) {
            case SHA0: {
                return "SHA0";
            }
            case SHA1: {
                return "SHA1";
            }
            case MD5: {
                return "MD5";
            }
        }
        throw new RuntimeException("Unknown algorithm: " + (Object)((Object)this.alg));
    }

    public void update(byte[] buffer, int offset, int length) {
        this.digest.update(buffer, offset, length);
        this.offset += (long)length;
    }

    public String toString() {
        String checksumData = this.getAlgorithmName() + "/" + this.offset + "/" + this.getHashValue();
        l4j.debug((Object)("Checksum Value: '" + checksumData + "'"));
        return checksumData;
    }

    private String getHashValue() {
        MessageDigest tmpDigest;
        try {
            tmpDigest = (MessageDigest)this.digest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone failed", e);
        }
        byte[] currDigest = tmpDigest.digest();
        BigInteger bigInt = new BigInteger(1, currDigest);
        return String.format("%0" + (currDigest.length << 1) + "x", bigInt);
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    static {
        Security.addProvider((Provider)new CryptixCrypto());
    }

    public static enum Algorithm {
        SHA0,
        SHA1,
        MD5;

    }
}

