/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api;

import com.emc.esu.api.Extent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MultiExtent
extends Extent
implements List<Extent> {
    private List<Extent> extents = new ArrayList<Extent>();

    public MultiExtent() {
        super(0L, 0L);
    }

    @Override
    public long getOffset() {
        if (this.extents.isEmpty()) {
            return -1L;
        }
        long start = Long.MAX_VALUE;
        for (Extent e : this.extents) {
            if (e.getOffset() >= start) continue;
            start = e.getOffset();
        }
        return start;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (Extent e : this.extents) {
            size += e.getSize();
        }
        return size;
    }

    @Override
    public String toString() {
        if (this.extents.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one extent");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("bytes=");
        boolean first = true;
        for (Extent e : this.extents) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            long end = e.getOffset() + (e.getSize() - 1L);
            sb.append(e.getOffset() + "-" + end);
        }
        return sb.toString();
    }

    @Override
    public boolean add(Extent e) {
        return this.extents.add(e);
    }

    @Override
    public void add(int i, Extent e) {
        this.extents.add(i, e);
    }

    @Override
    public boolean addAll(Collection<? extends Extent> c) {
        return this.extents.addAll(c);
    }

    @Override
    public boolean addAll(int i, Collection<? extends Extent> c) {
        return this.extents.addAll(i, c);
    }

    @Override
    public void clear() {
        this.extents.clear();
    }

    @Override
    public boolean contains(Object e) {
        return this.extents.contains(e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.extents.containsAll(c);
    }

    @Override
    public Extent get(int i) {
        return this.extents.get(i);
    }

    @Override
    public int indexOf(Object e) {
        return this.extents.indexOf(e);
    }

    @Override
    public boolean isEmpty() {
        return this.extents.isEmpty();
    }

    @Override
    public Iterator<Extent> iterator() {
        return this.extents.iterator();
    }

    @Override
    public int lastIndexOf(Object e) {
        return this.extents.lastIndexOf(e);
    }

    @Override
    public ListIterator<Extent> listIterator() {
        return this.extents.listIterator();
    }

    @Override
    public ListIterator<Extent> listIterator(int i) {
        return this.extents.listIterator(i);
    }

    @Override
    public boolean remove(Object e) {
        return this.extents.remove(e);
    }

    @Override
    public Extent remove(int i) {
        return this.extents.remove(i);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.extents.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.extents.retainAll(c);
    }

    @Override
    public Extent set(int i, Extent e) {
        return this.extents.set(i, e);
    }

    @Override
    public int size() {
        return this.extents.size();
    }

    @Override
    public List<Extent> subList(int i, int j) {
        return this.extents.subList(i, j);
    }

    @Override
    public Object[] toArray() {
        return this.extents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.extents.toArray(a);
    }
}

