/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api;

import com.emc.esu.api.EsuException;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.ObjectResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ObjectId
implements Identifier {
    private static final Pattern ID_FORMAT = Pattern.compile("^[0-9a-f]{44,}$");
    private String id;

    public ObjectId(String id) {
        if (!ID_FORMAT.matcher(id).matches()) {
            throw new EsuException(id + " is not a valid object id");
        }
        this.id = id;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectResult) {
            return this.equals(((ObjectResult)obj).getId());
        }
        if (!(obj instanceof ObjectId)) {
            return false;
        }
        return this.id.equals(((ObjectId)obj).toString());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static Date parseXmlDate(String dateText) {
        if (dateText == null || dateText.length() < 1) {
            return null;
        }
        SimpleDateFormat xmlDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        xmlDate.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date d = xmlDate.parse(dateText);
            return d;
        }
        catch (ParseException e) {
            throw new EsuException("Failed to parse date: " + dateText, e);
        }
    }
}

