/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api;

import com.emc.esu.api.EsuException;
import com.emc.esu.api.ObjectExpiration;
import com.emc.esu.api.ObjectId;
import com.emc.esu.api.ObjectReplica;
import com.emc.esu.api.ObjectRetention;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ObjectInfo {
    private String rawXml;
    private ObjectId objectId;
    private String selection;
    private List<ObjectReplica> replicas = new ArrayList<ObjectReplica>();
    private ObjectRetention retention;
    private ObjectExpiration expiration;

    public ObjectInfo() {
    }

    public ObjectInfo(String xml) {
        this.rawXml = xml;
        this.parse(xml);
    }

    public void parse(String xml) {
        SAXBuilder sb = new SAXBuilder();
        try {
            Document d = sb.build((Reader)new StringReader(xml));
            Namespace esuNs = Namespace.getNamespace((String)"http://www.emc.com/cos/");
            List children = d.getRootElement().getChildren("objectId", esuNs);
            if (children == null || children.size() < 1) {
                throw new EsuException("objectId not found in response");
            }
            this.objectId = new ObjectId(((Element)children.get(0)).getTextTrim());
            children = d.getRootElement().getChildren("selection", esuNs);
            if (children == null || children.size() < 1) {
                throw new EsuException("selection not found in response");
            }
            this.selection = ((Element)children.get(0)).getTextTrim();
            children = d.getRootElement().getChildren("replicas", esuNs);
            if (children == null || children.size() < 1) {
                throw new EsuException("replicas not found in response");
            }
            children = ((Element)children.get(0)).getChildren("replica", esuNs);
            for (Element replica : children) {
                this.replicas.add(new ObjectReplica(replica));
            }
            children = d.getRootElement().getChildren("expiration", esuNs);
            if (children == null || children.size() < 1) {
                throw new EsuException("expiration not found in response");
            }
            this.expiration = new ObjectExpiration((Element)children.get(0));
            children = d.getRootElement().getChildren("retention", esuNs);
            if (children == null || children.size() < 1) {
                throw new EsuException("retention not found in response");
            }
            this.retention = new ObjectRetention((Element)children.get(0));
        }
        catch (JDOMException e) {
            throw new EsuException("Error parsing object info", e);
        }
        catch (IOException e) {
            throw new EsuException("Error parsing object info", e);
        }
    }

    public String getRawXml() {
        return this.rawXml;
    }

    public void setRawXml(String rawXml) {
        this.rawXml = rawXml;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public String getSelection() {
        return this.selection;
    }

    public void setSelection(String selection) {
        this.selection = selection;
    }

    public List<ObjectReplica> getReplicas() {
        return this.replicas;
    }

    public void setReplicas(List<ObjectReplica> replicas) {
        this.replicas = replicas;
    }

    public ObjectRetention getRetention() {
        return this.retention;
    }

    public void setRetention(ObjectRetention retention) {
        this.retention = retention;
    }

    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }
}

