/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.Acl;
import com.emc.esu.api.BufferSegment;
import com.emc.esu.api.Checksum;
import com.emc.esu.api.DirectoryEntry;
import com.emc.esu.api.EsuException;
import com.emc.esu.api.Extent;
import com.emc.esu.api.Grantee;
import com.emc.esu.api.HttpInputStreamWrapper;
import com.emc.esu.api.Identifier;
import com.emc.esu.api.ListOptions;
import com.emc.esu.api.MetadataList;
import com.emc.esu.api.MetadataTag;
import com.emc.esu.api.MetadataTags;
import com.emc.esu.api.ObjectId;
import com.emc.esu.api.ObjectInfo;
import com.emc.esu.api.ObjectMetadata;
import com.emc.esu.api.ObjectPath;
import com.emc.esu.api.ObjectResult;
import com.emc.esu.api.ServiceInformation;
import com.emc.esu.api.Version;
import com.emc.esu.api.rest.AbstractEsuRestApi;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class EsuRestApi
extends AbstractEsuRestApi {
    private static final Logger l4j = Logger.getLogger(EsuRestApi.class);
    private Map<String, String> customHeaders;

    public EsuRestApi(String host, int port, String uid, String sharedSecret) {
        super(host, port, uid, sharedSecret);
    }

    @Override
    public ObjectId createObjectFromStreamOnPath(ObjectPath path, Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            con.setFixedLengthStreamingMode((int)length);
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            byte[] buffer = new byte[131072];
            int read = 0;
            try {
                out = con.getOutputStream();
                while ((long)read < length) {
                    int maxRead = (int)Math.min((long)buffer.length, length - (long)read);
                    int c = data.read(buffer, 0, maxRead);
                    if (c == -1) {
                        throw new EsuException("EOF encountered reading data stream");
                    }
                    out.write(buffer, 0, c);
                    read += c;
                }
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromStream(Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            con.setFixedLengthStreamingMode((int)length);
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            byte[] buffer = new byte[131072];
            int read = 0;
            try {
                out = con.getOutputStream();
                while ((long)read < length) {
                    int maxRead = (int)Math.min((long)buffer.length, length - (long)read);
                    int c = data.read(buffer, 0, maxRead);
                    if (c == -1) {
                        throw new EsuException("EOF encountered reading data stream");
                    }
                    out.write(buffer, 0, c);
                    read += c;
                }
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromSegment(Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            con.setFixedLengthStreamingMode(data.getSize());
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            try {
                out = con.getOutputStream();
                out.write(data.getBuffer(), data.getOffset(), data.getSize());
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectFromSegmentOnPath(ObjectPath path, Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            con.setFixedLengthStreamingMode(data.getSize());
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            try {
                out = con.getOutputStream();
                out.write(data.getBuffer(), data.getOffset(), data.getSize());
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteObject(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, null, headers);
            this.configureRequest(con, "DELETE", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteVersion(ObjectId id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, query, headers);
            this.configureRequest(con, "DELETE", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteUserMetadata(Identifier id, MetadataTags tags) {
        if (tags == null) {
            throw new EsuException("Must specify tags to delete");
        }
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, query, headers);
            this.configureRequest(con, "DELETE", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public Acl getAcl(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "acl";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            Acl acl = new Acl();
            this.readAcl(acl, con.getHeaderField("x-emc-useracl"), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, con.getHeaderField("x-emc-groupacl"), Grantee.GRANT_TYPE.GROUP);
            con.disconnect();
            return acl;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataTags getListableTags(MetadataTag tag) {
        return this.getListableTags(tag == null ? null : tag.getName());
    }

    @Override
    public MetadataTags getListableTags(String tag) {
        try {
            String resource = this.context + "/objects";
            String query = "listabletags";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tag != null) {
                headers.put("x-emc-tags", this.unicodeEnabled ? this.encodeUtf8(tag) : tag);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String header = con.getHeaderField("x-emc-listable-tags");
            l4j.debug((Object)("x-emc-listable-tags: " + header));
            MetadataTags tags = new MetadataTags();
            this.readTags(tags, header, true);
            con.disconnect();
            return tags;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(Identifier id, MetadataTags tags) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/system";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, con.getHeaderField("x-emc-meta"), false);
            this.readMetadata(meta, con.getHeaderField("x-emc-listable-meta"), true);
            con.disconnect();
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getUserMetadata(Identifier id, MetadataTags tags) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, con.getHeaderField("x-emc-meta"), false);
            this.readMetadata(meta, con.getHeaderField("x-emc-listable-meta"), true);
            con.disconnect();
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<ObjectResult> listObjects(String tag, ListOptions options) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (tag == null) {
                throw new EsuException("Tag cannot be null");
            }
            headers.put("x-emc-tags", this.unicodeEnabled ? this.encodeUtf8(tag) : tag);
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    headers.put("x-emc-include-meta", "1");
                    if (options.getSystemMetadata() != null) {
                        headers.put("x-emc-system-tags", this.join(options.getSystemMetadata(), ","));
                    }
                    if (options.getUserMetadata() != null) {
                        headers.put("x-emc-user-tags", this.join(options.getUserMetadata(), ","));
                    }
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            try {
                if (con.getResponseCode() > 299) {
                    this.handleError(con);
                }
            }
            catch (EsuException e) {
                if (e.getAtmosCode() == 1003) {
                    return Collections.emptyList();
                }
                throw e;
            }
            byte[] response = this.readResponse(con, null);
            l4j.debug((Object)("Response: " + new String(response, "UTF-8")));
            con.disconnect();
            if (options != null) {
                options.setToken(con.getHeaderField("x-emc-token"));
            } else if (con.getHeaderField("x-emc-token") != null) {
                l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
            }
            return this.parseObjectListWithMetadata(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataTags listUserMetadataTags(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/tags";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            MetadataTags tags = new MetadataTags();
            this.readTags(tags, con.getHeaderField("x-emc-listable-tags"), true);
            this.readTags(tags, con.getHeaderField("x-emc-tags"), false);
            con.disconnect();
            return tags;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<Identifier> listVersions(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            byte[] response = this.readResponse(con, null);
            l4j.debug((Object)("Response: " + new String(response, "UTF-8")));
            con.disconnect();
            return this.parseVersionList(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<Version> listVersions(ObjectId id, ListOptions options) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    l4j.warn((Object)"Include metadata is not supported for listVersions");
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            if (options != null) {
                options.setToken(con.getHeaderField("x-emc-token"));
            } else if (con.getHeaderField("x-emc-token") != null) {
                l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
            }
            byte[] response = this.readResponse(con, null);
            l4j.debug((Object)("Response: " + new String(response, "UTF-8")));
            con.disconnect();
            return this.parseVersionListLong(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<ObjectId> queryObjects(String xquery) {
        try {
            String resource = this.context + "/objects";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (xquery == null) {
                throw new EsuException("Query cannot be null");
            }
            headers.put("x-emc-xquery", xquery);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            Map<String, List<String>> responseHeaders = con.getHeaderFields();
            l4j.debug((Object)("Response headers: " + responseHeaders));
            byte[] response = this.readResponse(con, null);
            if (l4j.isDebugEnabled()) {
                String responseBody = new String(response, "UTF-8");
                l4j.debug((Object)("Response: " + responseBody));
            }
            con.disconnect();
            return this.parseObjectList(response);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public byte[] readObject(Identifier id, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            if (buffer != null && extent != null && extent.getSize() > (long)buffer.length) {
                throw new IllegalArgumentException("The buffer is smaller than the requested extent");
            }
            byte[] data = this.readResponse(con, buffer);
            String checksumStr = con.getHeaderField("x-emc-wschecksum");
            if (checksumStr != null && checksum != null) {
                l4j.debug((Object)("Checksum header: " + checksumStr));
                checksum.setExpectedValue(checksumStr);
                if (con.getContentLength() != -1) {
                    checksum.update(data, 0, con.getContentLength());
                } else {
                    checksum.update(data, 0, data.length);
                }
            }
            con.disconnect();
            return data;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public InputStream readObjectStream(Identifier id, Extent extent) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            return new HttpInputStreamWrapper(con.getInputStream(), con);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectFromSegment(Identifier id, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            con.setFixedLengthStreamingMode(data.getSize());
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("PUT", resource, null, headers);
            this.configureRequest(con, "PUT", headers);
            con.connect();
            OutputStream out = null;
            try {
                out = con.getOutputStream();
                out.write(data.getBuffer(), data.getOffset(), data.getSize());
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectFromStream(Identifier id, Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            con.setFixedLengthStreamingMode((int)length);
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, null, headers);
            this.configureRequest(con, "PUT", headers);
            con.connect();
            OutputStream out = null;
            byte[] buffer = new byte[131072];
            int read = 0;
            try {
                out = con.getOutputStream();
                while ((long)read < length) {
                    int maxRead = (int)Math.min((long)buffer.length, length - (long)read);
                    int c = data.read(buffer, 0, maxRead);
                    if (c == -1) {
                        throw new EsuException("EOF encountered reading data stream");
                    }
                    out.write(buffer, 0, c);
                    read += c;
                }
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void setUserMetadata(Identifier id, MetadataList metadata) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "metadata/user";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            InputStream in = con.getInputStream();
            in.close();
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void setAcl(Identifier id, Acl acl) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "acl";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            InputStream in = con.getInputStream();
            in.close();
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId versionObject(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public List<DirectoryEntry> listDirectory(ObjectPath path, ListOptions options) {
        if (!path.isDirectory()) {
            throw new EsuException("listDirectory must be called with a directory path");
        }
        byte[] data = null;
        try {
            String resource = this.getResourcePath(this.context, path);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if (options != null) {
                if (options.isIncludeMetadata()) {
                    headers.put("x-emc-include-meta", "1");
                    if (options.getSystemMetadata() != null) {
                        headers.put("x-emc-system-tags", this.join(options.getSystemMetadata(), ","));
                    }
                    if (options.getUserMetadata() != null) {
                        headers.put("x-emc-user-tags", this.join(options.getUserMetadata(), ","));
                    }
                }
                if (options.getLimit() > 0) {
                    headers.put("x-emc-limit", "" + options.getLimit());
                }
                if (options.getToken() != null) {
                    headers.put("x-emc-token", options.getToken());
                }
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            if (options != null) {
                options.setToken(con.getHeaderField("x-emc-token"));
            } else if (con.getHeaderField("x-emc-token") != null) {
                l4j.warn((Object)"Result set truncated. Use ListOptions to retrieve token for next page of results.");
            }
            data = this.readResponse(con, null);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
        return this.parseDirectoryListing(data, path);
    }

    @Override
    public ObjectMetadata getAllMetadata(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("HEAD", resource, null, headers);
            this.configureRequest(con, "HEAD", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            Acl acl = new Acl();
            this.readAcl(acl, con.getHeaderField("x-emc-useracl"), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, con.getHeaderField("x-emc-groupacl"), Grantee.GRANT_TYPE.GROUP);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, con.getHeaderField("x-emc-meta"), false);
            this.readMetadata(meta, con.getHeaderField("x-emc-listable-meta"), true);
            ObjectMetadata om = new ObjectMetadata();
            om.setAcl(acl);
            om.setMetadata(meta);
            om.setMimeType(con.getContentType());
            return om;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ServiceInformation getServiceInformation() {
        try {
            String resource = this.context + "/service";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            byte[] response = this.readResponse(con, null);
            l4j.debug((Object)("Response: " + new String(response, "UTF-8")));
            con.disconnect();
            return this.parseServiceInformation(response, con.getHeaderFields());
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void rename(ObjectPath source, ObjectPath destination, boolean force) {
        try {
            String destPath;
            String resource = this.getResourcePath(this.context, source);
            String query = "rename";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            if ((destPath = destination.toString()).startsWith("/")) {
                destPath = destPath.substring(1);
            }
            headers.put("x-emc-path", this.unicodeEnabled ? this.encodeUtf8(destPath) : destPath);
            if (force) {
                headers.put("x-emc-force", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void restoreVersion(ObjectId id, ObjectId vId) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "versions";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-version-oid", vId.toString());
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, query, headers);
            this.configureRequest(con, "PUT", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectInfo getObjectInfo(Identifier id) {
        try {
            String resource = this.getResourcePath(this.context, id);
            String query = "info";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            byte[] response = this.readResponse(con, null);
            String responseXml = new String(response, "UTF-8");
            l4j.debug((Object)("Response: " + responseXml));
            con.disconnect();
            return new ObjectInfo(responseXml);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public long calculateServerOffset() {
        try {
            String resource = this.context + "/";
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            con.connect();
            Date serverDate = new Date(con.getHeaderFieldDate("Date", 0L));
            if (serverDate.getTime() == 0L) {
                EsuException e = new EsuException("Unable to get date from server request: " + con.getResponseMessage(), con.getResponseCode());
                throw e;
            }
            return System.currentTimeMillis() - serverDate.getTime();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    protected void configureRequest(HttpURLConnection con, String method, Map<String, String> headers) throws ProtocolException, UnsupportedEncodingException {
        if (this.getCustomHeaders() != null) {
            headers.putAll(this.getCustomHeaders());
        }
        for (String name : headers.keySet()) {
            con.setRequestProperty(name, headers.get(name));
        }
        con.setRequestMethod(method);
    }

    protected void signRequest(String method, String path, String query, Map<String, String> headers) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.appendBytes(out, method + "\n", null);
        if (headers.containsKey("Content-Type")) {
            l4j.debug((Object)("Content-Type: " + headers.get("Content-Type")));
            this.appendBytes(out, headers.get("Content-Type") + "\n", null);
        } else {
            this.appendBytes(out, "\n", null);
        }
        if (headers.containsKey("Range")) {
            this.appendBytes(out, headers.get("Range") + "\n", null);
        } else if (headers.containsKey("Content-Range")) {
            this.appendBytes(out, headers.get("Content-Range") + "\n", null);
        } else {
            this.appendBytes(out, "\n", null);
        }
        this.appendBytes(out, headers.get("Date") + "\n" + path.toLowerCase(), "UTF-8");
        if (query != null) {
            this.appendBytes(out, "?" + query + "\n", "UTF-8");
        } else {
            this.appendBytes(out, "\n", null);
        }
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, String> newheaders = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            if (key.indexOf("x-emc") != 0) continue;
            keys.add(key.toLowerCase());
            newheaders.put(key.toLowerCase(), headers.get(key).replace("\n", ""));
        }
        Collections.sort(keys);
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                this.appendBytes(out, "\n", null);
            } else {
                first = false;
            }
            this.appendBytes(out, key + ':' + this.normalizeSpace((String)newheaders.get(key)), null);
        }
        byte[] data = out.toByteArray();
        l4j.debug((Object)("Hashing:\n" + new String(data, "UTF-8")));
        String hashOut = this.sign(data);
        headers.put("x-emc-signature", hashOut);
    }

    private void appendBytes(OutputStream out, String s, String encoding) throws UnsupportedEncodingException, IOException {
        if (encoding == null) {
            out.write(s.getBytes());
        } else {
            out.write(s.getBytes(encoding));
        }
    }

    protected void handleError(HttpURLConnection con) {
        int http_code = 0;
        try {
            http_code = con.getResponseCode();
            byte[] response = this.readResponse(con, null);
            l4j.debug((Object)("Error response: " + new String(response, "UTF-8")));
            SAXBuilder sb = new SAXBuilder();
            Document d = sb.build((InputStream)new ByteArrayInputStream(response));
            String code = d.getRootElement().getChildText("Code");
            String message = d.getRootElement().getChildText("Message");
            if (code == null && message == null) {
                throw new EsuException(con.getResponseMessage(), http_code);
            }
            l4j.debug((Object)("Error: " + code + " message: " + message));
            throw new EsuException(message, http_code, Integer.parseInt(code));
        }
        catch (IOException e) {
            l4j.debug((Object)"Could not read error response body", (Throwable)e);
            try {
                throw new EsuException(con.getResponseMessage(), http_code);
            }
            catch (IOException e1) {
                l4j.warn((Object)"Could not get response code/message!", (Throwable)e);
                throw new EsuException("Could not get response code", e, http_code);
            }
        }
        catch (JDOMException e) {
            try {
                l4j.debug((Object)("Could not parse response body for " + http_code + ": " + con.getResponseMessage()), (Throwable)e);
                throw new EsuException("Could not parse response body for " + http_code + ": " + con.getResponseMessage(), e, http_code);
            }
            catch (IOException e1) {
                throw new EsuException("Could not parse response body", e1, http_code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readResponse(HttpURLConnection con, byte[] buffer) throws IOException {
        InputStream in = null;
        if (con.getResponseCode() > 299) {
            in = con.getErrorStream();
            if (in == null) {
                in = con.getInputStream();
            }
        } else {
            in = con.getInputStream();
        }
        if (in == null) {
            return new byte[0];
        }
        try {
            int contentLength = con.getContentLength();
            if (contentLength != -1) {
                int read2;
                if (buffer != null && buffer.length < con.getContentLength()) {
                    throw new EsuException("The response buffer was not long enough to hold the response: " + buffer.length + "<" + con.getContentLength());
                }
                byte[] output = buffer != null ? buffer : new byte[con.getContentLength()];
                for (int c = 0; c < contentLength; c += read2) {
                    read2 = in.read(output, c, contentLength - c);
                    if (read2 != -1) continue;
                    throw new EOFException("EOF reading response at position " + c + " size " + (contentLength - c));
                }
                byte[] read2 = output;
                return read2;
            }
            l4j.debug((Object)"Content length is unknown.  Buffering output.");
            if (buffer == null) {
                buffer = new byte[4096];
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = 0;
            while ((c = in.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.close();
            l4j.debug((Object)("Buffered " + baos.size() + " response bytes"));
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    @Override
    public void hardLink(ObjectPath source, ObjectPath target) {
        try {
            String resource = this.getResourcePath(this.context, source);
            String query = "hardlink";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            String destPath = target.toString();
            if (destPath.startsWith("/")) {
                destPath = destPath.substring(1);
            }
            headers.put("x-emc-path", destPath);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, query, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            con.setFixedLengthStreamingMode(data.getSize());
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            try {
                out = con.getOutputStream();
                out.write(data.getBuffer(), data.getOffset(), data.getSize());
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectId createObjectWithKeyFromStream(String keyPool, String key, Acl acl, MetadataList metadata, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            if (data == null) {
                throw new IllegalArgumentException("Input stream is required");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            con.setFixedLengthStreamingMode((int)length);
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            this.signRequest("POST", resource, null, headers);
            this.configureRequest(con, "POST", headers);
            con.connect();
            OutputStream out = null;
            byte[] buffer = new byte[131072];
            int read = 0;
            try {
                out = con.getOutputStream();
                while ((long)read < length) {
                    int maxRead = (int)Math.min((long)buffer.length, length - (long)read);
                    int c = data.read(buffer, 0, maxRead);
                    if (c == -1) {
                        throw new EsuException("EOF encountered reading data stream");
                    }
                    out.write(buffer, 0, c);
                    read += c;
                }
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            String location = con.getHeaderField("location");
            con.disconnect();
            return this.getObjectId(location);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void deleteObjectWithKey(String keyPool, String key) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            this.signRequest("DELETE", resource, null, headers);
            this.configureRequest(con, "DELETE", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public ObjectMetadata getAllMetadata(String keyPool, String key) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (this.unicodeEnabled) {
                headers.put("x-emc-utf8", "true");
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("HEAD", resource, null, headers);
            this.configureRequest(con, "HEAD", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            Acl acl = new Acl();
            this.readAcl(acl, con.getHeaderField("x-emc-useracl"), Grantee.GRANT_TYPE.USER);
            this.readAcl(acl, con.getHeaderField("x-emc-groupacl"), Grantee.GRANT_TYPE.GROUP);
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, con.getHeaderField("x-emc-meta"), false);
            this.readMetadata(meta, con.getHeaderField("x-emc-listable-meta"), true);
            ObjectMetadata om = new ObjectMetadata();
            om.setAcl(acl);
            om.setMetadata(meta);
            om.setMimeType(con.getContentType());
            return om;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public MetadataList getSystemMetadata(String keyPool, String key, MetadataTags tags) {
        try {
            String resource = this.context + "/namespace/" + key;
            String query = "metadata/system";
            URL u = this.buildUrl(resource, query);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (tags != null) {
                this.processTags(tags, headers);
            }
            headers.put("Date", this.getDateHeader());
            this.signRequest("GET", resource, query, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            MetadataList meta = new MetadataList();
            this.readMetadata(meta, con.getHeaderField("x-emc-meta"), false);
            this.readMetadata(meta, con.getHeaderField("x-emc-listable-meta"), true);
            con.disconnect();
            return meta;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public byte[] readObjectWithKey(String keyPool, String key, Extent extent, byte[] buffer, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            if (buffer != null && extent != null && extent.getSize() > (long)buffer.length) {
                throw new IllegalArgumentException("The buffer is smaller than the requested extent");
            }
            byte[] data = this.readResponse(con, buffer);
            String checksumStr = con.getHeaderField("x-emc-wschecksum");
            if (checksumStr != null && checksum != null) {
                l4j.debug((Object)("Checksum header: " + checksumStr));
                checksum.setExpectedValue(checksumStr);
                if (con.getContentLength() != -1) {
                    checksum.update(data, 0, con.getContentLength());
                } else {
                    checksum.update(data, 0, data.length);
                }
            }
            con.disconnect();
            return data;
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public InputStream readObjectStreamWithKey(String keyPool, String key, Extent extent) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            headers.put("Date", this.getDateHeader());
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            this.signRequest("GET", resource, null, headers);
            this.configureRequest(con, "GET", headers);
            con.connect();
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            return new HttpInputStreamWrapper(con.getInputStream(), con);
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectWithKeyFromStream(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, InputStream data, long length, String mimeType) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            con.setFixedLengthStreamingMode((int)length);
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            this.signRequest("PUT", resource, null, headers);
            this.configureRequest(con, "PUT", headers);
            con.connect();
            OutputStream out = null;
            byte[] buffer = new byte[131072];
            int read = 0;
            try {
                out = con.getOutputStream();
                while ((long)read < length) {
                    int maxRead = (int)Math.min((long)buffer.length, length - (long)read);
                    int c = data.read(buffer, 0, maxRead);
                    if (c == -1) {
                        throw new EsuException("EOF encountered reading data stream");
                    }
                    out.write(buffer, 0, c);
                    read += c;
                }
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }

    @Override
    public void updateObjectWithKeyFromSegment(String keyPool, String key, Acl acl, MetadataList metadata, Extent extent, BufferSegment data, String mimeType, Checksum checksum) {
        try {
            String resource = this.context + "/namespace/" + key;
            URL u = this.buildUrl(resource, null);
            HttpURLConnection con = (HttpURLConnection)u.openConnection();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            headers.put("Content-Type", mimeType);
            headers.put("x-emc-uid", this.uid);
            headers.put("x-emc-pool", keyPool);
            if (metadata != null) {
                this.processMetadata(metadata, headers);
            }
            l4j.debug((Object)("meta " + (String)headers.get("x-emc-meta")));
            if (acl != null) {
                this.processAcl(acl, headers);
            }
            if (extent != null && !extent.equals(Extent.ALL_CONTENT)) {
                headers.put(extent.getHeaderName(), extent.toString());
            }
            if (data == null) {
                data = new BufferSegment(new byte[0]);
            }
            con.setFixedLengthStreamingMode(data.getSize());
            con.setDoOutput(true);
            headers.put("Date", this.getDateHeader());
            if (checksum != null) {
                checksum.update(data.getBuffer(), data.getOffset(), data.getSize());
                headers.put("x-emc-wschecksum", checksum.toString());
            }
            this.signRequest("PUT", resource, null, headers);
            this.configureRequest(con, "PUT", headers);
            con.connect();
            OutputStream out = null;
            try {
                out = con.getOutputStream();
                out.write(data.getBuffer(), data.getOffset(), data.getSize());
                out.close();
            }
            catch (IOException e) {
                this.silentClose(out);
                con.disconnect();
                throw new EsuException("Error posting data", e);
            }
            if (con.getResponseCode() > 299) {
                this.handleError(con);
            }
            con.disconnect();
        }
        catch (MalformedURLException e) {
            throw new EsuException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new EsuException("Error connecting to server", e);
        }
        catch (GeneralSecurityException e) {
            throw new EsuException("Error computing request signature", e);
        }
        catch (URISyntaxException e) {
            throw new EsuException("Invalid URL", e);
        }
    }
}

