/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.api.rest;

import com.emc.esu.api.rest.EsuRestApi;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;

public class LBEsuRestApi
extends EsuRestApi {
    private static final Logger l4j = Logger.getLogger(LBEsuRestApi.class);
    private List<String> hosts;
    private long requestCount = 0L;
    private LBMode mode = LBMode.ROUND_ROBIN_THREADS;
    private ThreadLocal<String> threadHost = new ThreadLocal();

    public LBEsuRestApi(List<String> hosts, int port, String uid, String sharedSecret) {
        super(hosts.get(0), port, uid, sharedSecret);
        this.hosts = hosts;
    }

    @Override
    protected URL buildUrl(String resource, String query) throws URISyntaxException, MalformedURLException {
        int uriport = 0;
        uriport = "http".equals(this.proto) && this.port == 80 ? -1 : ("https".equals(this.proto) && this.port == 443 ? -1 : this.port);
        String host = null;
        if (this.mode == LBMode.ROUND_ROBIN_THREADS) {
            if (this.threadHost.get() == null) {
                this.threadHost.set(this.hosts.get((int)(this.requestCount++ % (long)this.hosts.size())));
                l4j.info((Object)("Thread bound to " + this.threadHost.get()));
            }
            host = this.threadHost.get();
        } else {
            host = this.hosts.get((int)(this.requestCount++ % (long)this.hosts.size()));
        }
        URI uri = new URI(this.proto, null, host, uriport, resource, query, null);
        l4j.debug((Object)("URI: " + uri));
        URL u = new URL(uri.toASCIIString());
        l4j.debug((Object)("URL: " + u));
        return u;
    }

    public void setMode(LBMode mode) {
        this.mode = mode;
    }

    public LBMode getMode() {
        return this.mode;
    }

    public static enum LBMode {
        ROUND_ROBIN,
        ROUND_ROBIN_THREADS;

    }
}

