/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt;

import com.emc.esu.api.EsuException;
import com.emc.esu.sysmgmt.SysMgmtResponse;
import com.emc.esu.sysmgmt.SysMgmtUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ListHostsResponse
extends SysMgmtResponse {
    private List<Host> hosts;

    public ListHostsResponse(HttpURLConnection con) throws IOException, JDOMException {
        super(con);
        Document doc = SysMgmtUtils.parseResponseXml(con);
        Element root = doc.getRootElement();
        this.hosts = new ArrayList<Host>();
        List hostsXml = root.getChildren("node");
        for (Object o : hostsXml) {
            if (!(o instanceof Element)) {
                throw new EsuException("Expected XML Element got " + o.getClass());
            }
            Element e = (Element)o;
            Host h = new Host();
            h.setName(e.getAttributeValue("name"));
            h.setUp(Boolean.parseBoolean(e.getAttributeValue("up")));
            h.setLocation(e.getAttributeValue("location"));
            this.hosts.add(h);
        }
    }

    public List<Host> getHosts() {
        return this.hosts;
    }

    public class Host {
        private String name;
        private boolean up;
        private String location;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isUp() {
            return this.up;
        }

        public void setUp(boolean up) {
            this.up = up;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String toString() {
            return "Host [name=" + this.name + ", up=" + this.up + ", location=" + this.location + "]";
        }
    }
}

