/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt;

import com.emc.esu.sysmgmt.ListHostsRequest;
import com.emc.esu.sysmgmt.ListHostsResponse;
import com.emc.esu.sysmgmt.ListRmgRequest;
import com.emc.esu.sysmgmt.ListRmgResponse;
import com.emc.esu.sysmgmt.pox.GetUidRequest;
import com.emc.esu.sysmgmt.pox.GetUidResponse;
import com.emc.esu.sysmgmt.pox.ListRmgRequestPox;
import com.emc.esu.sysmgmt.pox.ListRmgResponsePox;
import com.emc.util.HttpUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class SysMgmtApi {
    private static final Logger l4j = Logger.getLogger(SysMgmtApi.class);
    private String proto;
    private String host;
    private int port;
    private String username;
    private String password;
    private String poxCookie;

    public SysMgmtApi() {
        this.port = 443;
        this.proto = "https";
    }

    public SysMgmtApi(String proto, String host, int port, String username, String password) {
        this.proto = proto;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public ListRmgResponse listRmgs() {
        ListRmgRequest req = new ListRmgRequest(this);
        return req.call();
    }

    public ListRmgResponsePox listRmgsPox() throws Exception {
        if (this.poxCookie == null) {
            throw new RuntimeException("Not logged in to POX");
        }
        ListRmgRequestPox req = new ListRmgRequestPox(this);
        return req.call();
    }

    public ListHostsResponse listHosts(String rmgName) {
        ListHostsRequest req = new ListHostsRequest(this, rmgName);
        return req.call();
    }

    public String getProto() {
        return this.proto;
    }

    public void setProto(String proto) {
        this.proto = proto;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    String getPassword() {
        return this.password;
    }

    public static void disableCertificateValidation() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    public String getPoxCookie() {
        return this.poxCookie;
    }

    public void poxLogin(String tenantName, String tenantAdmin, String tenantAdminPassword) throws IOException, URISyntaxException {
        URI uri = new URI(this.proto, null, this.host, this.port, "/user/verify", null, null);
        l4j.debug((Object)("URI: " + uri));
        URL u = new URL(uri.toASCIIString());
        l4j.debug((Object)("URL: " + u));
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        con.addRequestProperty("Accept", "application/xml");
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.connect();
        OutputStream out = con.getOutputStream();
        String urlTenantName = HttpUtil.encodeUtf8(tenantName);
        String urluser = HttpUtil.encodeUtf8(tenantAdmin);
        String urlpass = HttpUtil.encodeUtf8(tenantAdminPassword);
        String requestBody = "tenant_name=" + urlTenantName + "&username=" + urluser + "&password=" + urlpass;
        out.write(requestBody.getBytes("US-ASCII"));
        out.close();
        int code = con.getResponseCode();
        if (code != 200) {
            throw new RuntimeException("Login failed with HTTP code " + code);
        }
        String cookies = con.getHeaderField("Set-Cookie");
        Pattern cookiePattern = Pattern.compile("_gui_session_id=([^;]+);.*");
        Matcher m = cookiePattern.matcher(cookies);
        if (!m.find()) {
            throw new RuntimeException("Could not parse session cookie from " + cookies);
        }
        this.poxCookie = m.group(1);
    }

    public void poxLogin() throws IOException, URISyntaxException {
        URI uri = new URI(this.proto, null, this.host, this.port, "/mgmt_login/verify", null, null);
        l4j.debug((Object)("URI: " + uri));
        URL u = new URL(uri.toASCIIString());
        l4j.debug((Object)("URL: " + u));
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        con.addRequestProperty("Accept", "application/xml");
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.connect();
        OutputStream out = con.getOutputStream();
        String urluser = HttpUtil.encodeUtf8(this.username);
        String urlpass = HttpUtil.encodeUtf8(this.password);
        String requestBody = "auth_type=local&auth_addr=&username=" + urluser + "&password=" + urlpass;
        out.write(requestBody.getBytes("US-ASCII"));
        out.close();
        int code = con.getResponseCode();
        if (code != 200) {
            throw new RuntimeException("Login failed with HTTP code " + code);
        }
        String cookies = con.getHeaderField("Set-Cookie");
        Pattern cookiePattern = Pattern.compile("_gui_session_id=([^;]+);.*");
        Matcher m = cookiePattern.matcher(cookies);
        if (!m.find()) {
            throw new RuntimeException("Could not parse session cookie from " + cookies);
        }
        this.poxCookie = m.group(1);
    }

    public GetUidResponse getUidPox(String subTenantName, String uid) throws Exception {
        GetUidRequest req = new GetUidRequest(this);
        req.setUid(uid);
        req.setSubTenantName(subTenantName);
        return req.call();
    }
}

