/*
 * Decompiled with CFR 0.152.
 */
package com.emc.esu.sysmgmt.pox;

import com.emc.esu.api.EsuException;
import com.emc.esu.sysmgmt.SysMgmtUtils;
import com.emc.esu.sysmgmt.pox.PoxResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class ListRmgResponsePox
extends PoxResponse {
    private List<Rmg> rmgs;

    public ListRmgResponsePox(HttpURLConnection con) throws IOException, JDOMException {
        Document doc = SysMgmtUtils.parseResponseXml(con);
        Element root = doc.getRootElement();
        this.rmgs = new ArrayList<Rmg>();
        List rmgsXml = root.getChildren("rmg");
        if (rmgsXml.size() < 1) {
            this.setSuccessful(false);
            this.setError(root.getTextTrim());
            return;
        }
        for (Object o : rmgsXml) {
            if (!(o instanceof Element)) {
                throw new EsuException("Expected XML Element got " + o.getClass());
            }
            Element e = (Element)o;
            Rmg r = new Rmg();
            r.setName(e.getChildText("name"));
            r.setId(Integer.parseInt(e.getChildText("id")));
            r.setLocation(e.getChildText("location"));
            r.setCapacity(e.getChildText("capacity"));
            r.setMulticastAddress(e.getChildText("multicast_address"));
            this.rmgs.add(r);
        }
    }

    public List<Rmg> getRmgs() {
        return this.rmgs;
    }

    public static class Rmg {
        private String name;
        private int id;
        private String location;
        private String capacity;
        private String multicastAddress;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public String getMulticastAddress() {
            return this.multicastAddress;
        }

        public void setMulticastAddress(String multicastAddress) {
            this.multicastAddress = multicastAddress;
        }
    }
}

