/*
 * Decompiled with CFR 0.152.
 */
package com.emc.vipr.transform.encryption;

import com.emc.vipr.transform.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class EncryptionOutputStream
extends OutputStream {
    boolean closed = false;
    byte[] digest = null;
    private DigestOutputStream digestStream;
    private CountingOutputStream counterStream;

    public EncryptionOutputStream(OutputStream out, Cipher cipher, MessageDigest digest) {
        CipherOutputStream cipherStream = new CipherOutputStream(out, cipher);
        if (digest != null) {
            this.digestStream = new DigestOutputStream(cipherStream, digest);
            this.counterStream = new CountingOutputStream(this.digestStream);
        } else {
            this.counterStream = new CountingOutputStream(cipherStream);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.counterStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.counterStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.counterStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.counterStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.counterStream.close();
        if (this.digestStream != null) {
            this.digest = this.digestStream.getMessageDigest().digest();
        }
    }

    public byte[] getDigest() {
        if (!this.closed) {
            throw new IllegalStateException("Cannot call getDigest until stream closed");
        }
        return this.digest;
    }

    public long getByteCount() {
        return this.counterStream.getByteCount();
    }
}

