/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.listeners.ItemStatus;
import com.google.common.collect.ImmutableMap;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Match;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Utils {
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String METHOD_FIELD_NAME = "method";
    public static final String ONE_SPACE = "\u00a0";
    private static final String NEW_LINE = "\r\n";
    public static final String TABLE_INDENT = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TABLE_COLUMN_SEPARATOR = "|";
    public static final String TABLE_ROW_SEPARATOR = "-";
    public static final Map<String, ItemStatus> STATUS_MAPPING = ImmutableMap.builder().put((Object)"passed", (Object)ItemStatus.PASSED).put((Object)"failed", (Object)ItemStatus.FAILED).put((Object)"skipped", (Object)ItemStatus.SKIPPED).put((Object)"pending", (Object)ItemStatus.SKIPPED).put((Object)"undefined", (Object)ItemStatus.SKIPPED).build();
    public static final Map<String, String> LOG_LEVEL_MAPPING = ImmutableMap.builder().put((Object)"passed", (Object)"INFO").put((Object)"failed", (Object)"ERROR").put((Object)"skipped", (Object)"WARN").put((Object)"pending", (Object)"WARN").put((Object)"undefined", (Object)"WARN").build();
    public static final Function<List<Argument>, List<?>> ARGUMENTS_TRANSFORM = arguments -> Optional.ofNullable(arguments).map(args -> args.stream().map(Argument::getVal).collect(Collectors.toList())).orElse(null);

    private Utils() {
    }

    @Nonnull
    public static String buildName(@Nullable String prefix, @Nullable String infix, @Nullable String argument) {
        return (prefix == null ? "" : prefix) + infix + argument;
    }

    @Nullable
    public static Method retrieveMethod(@Nonnull Match match) throws NoSuchFieldException, IllegalAccessException {
        Field stepDefinitionField = match.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
        stepDefinitionField.setAccessible(true);
        Object javaStepDefinition = stepDefinitionField.get(match);
        Field methodField = javaStepDefinition.getClass().getDeclaredField(METHOD_FIELD_NAME);
        methodField.setAccessible(true);
        return (Method)methodField.get(javaStepDefinition);
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table) {
        StringBuilder result = new StringBuilder();
        int tableLength = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        List colSizes = IntStream.range(0, tableLength).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).map(col -> col.stream().mapToInt(String::length).max().orElse(0)).collect(Collectors.toList());
        boolean header = true;
        for (List<String> row : table) {
            int i;
            result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
            for (i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                int maxSize = (Integer)colSizes.get(i) - cell.length() + 2;
                int lSpace = maxSize / 2;
                int rSpace = maxSize - lSpace;
                IntStream.range(0, lSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(cell);
                IntStream.range(0, rSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(TABLE_COLUMN_SEPARATOR);
            }
            if (header) {
                header = false;
                result.append(NEW_LINE);
                result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
                for (i = 0; i < row.size(); ++i) {
                    int maxSize = (Integer)colSizes.get(i) + 2;
                    IntStream.range(0, maxSize).forEach(j -> result.append(TABLE_ROW_SEPARATOR));
                    result.append(TABLE_COLUMN_SEPARATOR);
                }
            }
            result.append(NEW_LINE);
        }
        return result.toString().trim();
    }
}

