/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Date;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;

public abstract class AbstractReporter
implements ConcurrentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    protected static final String COLON_INFIX = ": ";
    protected RunningContext.FeatureContext currentFeatureContext;
    protected RunningContext.ScenarioContext currentScenarioContext;
    protected Supplier<Launch> RP;

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.getTestRunStartedHandler());
        publisher.registerHandlerFor(TestSourceRead.class, this.getTestSourceReadHandler());
        publisher.registerHandlerFor(TestCaseStarted.class, this.getTestCaseStartedHandler());
        publisher.registerHandlerFor(TestStepStarted.class, this.getTestStepStartedHandler());
        publisher.registerHandlerFor(TestStepFinished.class, this.getTestStepFinishedHandler());
        publisher.registerHandlerFor(TestCaseFinished.class, this.getTestCaseFinishedHandler());
        publisher.registerHandlerFor(TestRunFinished.class, this.getTestRunFinishedHandler());
        publisher.registerHandlerFor(EmbedEvent.class, this.getEmbedEventHandler());
        publisher.registerHandlerFor(WriteEvent.class, this.getWriteEventHandler());
    }

    protected void beforeLaunch() {
        this.startLaunch();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        ((Launch)this.RP.get()).finish(finishLaunchRq);
    }

    protected void beforeFeature() {
        this.startFeature();
    }

    protected void afterFeature() {
        Utils.finishTestItem((Launch)this.RP.get(), this.currentFeatureContext.getFeatureId());
        this.currentFeatureContext = null;
    }

    protected void beforeScenario() {
        Maybe<String> id = Utils.startNonLeafNode((Launch)this.RP.get(), this.currentFeatureContext.getFeatureId(), Utils.buildNodeName(this.currentScenarioContext.getKeyword(), COLON_INFIX, this.currentScenarioContext.getName(), this.currentScenarioContext.getOutlineIteration()), this.currentFeatureContext.getUri() + ":" + this.currentScenarioContext.getLine(), this.currentScenarioContext.getTags(), this.getScenarioTestItemType());
        this.currentScenarioContext.setId(id);
    }

    protected void afterScenario(TestCaseFinished event) {
        Utils.finishTestItem((Launch)this.RP.get(), this.currentScenarioContext.getId(), event.result.getStatus().toString());
        this.currentScenarioContext = null;
    }

    protected void startFeature() {
        StartTestItemRQ rq = new StartTestItemRQ();
        Maybe<String> root = this.getRootItemId();
        rq.setDescription(this.currentFeatureContext.getUri());
        rq.setName(Utils.buildNodeName(this.currentFeatureContext.getFeature().getKeyword(), COLON_INFIX, this.currentFeatureContext.getFeature().getName(), null));
        rq.setTags(this.currentFeatureContext.getTags());
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(this.getFeatureTestItemType());
        if (null == root) {
            this.currentFeatureContext.setFeatureId((Maybe<String>)((Launch)this.RP.get()).startTestItem(rq));
        } else {
            this.currentFeatureContext.setFeatureId((Maybe<String>)((Launch)this.RP.get()).startTestItem(root, rq));
        }
    }

    protected void startLaunch() {
        this.RP = Suppliers.memoize((Supplier)new Supplier<Launch>(){
            private final Date startTime = Calendar.getInstance().getTime();

            public Launch get() {
                ReportPortal reportPortal = ReportPortal.builder().build();
                ListenerParameters parameters = reportPortal.getParameters();
                StartLaunchRQ rq = new StartLaunchRQ();
                rq.setName(parameters.getLaunchName());
                rq.setStartTime(this.startTime);
                rq.setMode(parameters.getLaunchRunningMode());
                rq.setTags(parameters.getTags());
                rq.setDescription(parameters.getDescription());
                Launch launch = reportPortal.newLaunch(rq);
                return launch;
            }
        });
    }

    protected abstract void beforeStep(TestStep var1);

    protected abstract void afterStep(Result var1);

    protected abstract void beforeHooks(Boolean var1);

    protected abstract void afterHooks(Boolean var1);

    protected abstract void hookFinished(TestStep var1, Result var2, Boolean var3);

    protected abstract String getFeatureTestItemType();

    protected abstract String getScenarioTestItemType();

    protected void reportResult(Result result, String message) {
        String cukesStatus = result.getStatus().toString();
        String level = Utils.mapLevel(cukesStatus);
        String errorMessage = result.getErrorMessage();
        if (errorMessage != null) {
            Utils.sendLog(errorMessage, level, null);
        }
        if (message != null) {
            Utils.sendLog(message, level, null);
        }
    }

    protected void embedding(String mimeType, byte[] data) {
        String embeddingName;
        SaveLogRQ.File file = new SaveLogRQ.File();
        try {
            embeddingName = MimeTypes.getDefaultMimeTypes().forName(mimeType).getType().getType();
        }
        catch (MimeTypeException e) {
            LOGGER.warn("Mime-type not found", (Throwable)e);
            embeddingName = "embedding";
        }
        file.setName(embeddingName);
        file.setContent(data);
        Utils.sendLog(embeddingName, "UNKNOWN", file);
    }

    protected void write(String text) {
        Utils.sendLog(text, "INFO", null);
    }

    protected boolean isBefore(TestStep step) {
        return HookType.Before == ((HookTestStep)step).getHookType();
    }

    protected abstract Maybe<String> getRootItemId();

    private EventHandler<TestRunStarted> getTestRunStartedHandler() {
        return new EventHandler<TestRunStarted>(){

            public void receive(TestRunStarted event) {
                AbstractReporter.this.beforeLaunch();
            }
        };
    }

    private EventHandler<TestSourceRead> getTestSourceReadHandler() {
        return new EventHandler<TestSourceRead>(){

            public void receive(TestSourceRead event) {
                RunningContext.FeatureContext.addTestSourceReadEvent(event.uri, event);
            }
        };
    }

    private EventHandler<TestCaseStarted> getTestCaseStartedHandler() {
        return new EventHandler<TestCaseStarted>(){

            public void receive(TestCaseStarted event) {
                AbstractReporter.this.handleStartOfTestCase(event);
            }
        };
    }

    private EventHandler<TestStepStarted> getTestStepStartedHandler() {
        return new EventHandler<TestStepStarted>(){

            public void receive(TestStepStarted event) {
                AbstractReporter.this.handleTestStepStarted(event);
            }
        };
    }

    private EventHandler<TestStepFinished> getTestStepFinishedHandler() {
        return new EventHandler<TestStepFinished>(){

            public void receive(TestStepFinished event) {
                AbstractReporter.this.handleTestStepFinished(event);
            }
        };
    }

    private EventHandler<TestCaseFinished> getTestCaseFinishedHandler() {
        return new EventHandler<TestCaseFinished>(){

            public void receive(TestCaseFinished event) {
                AbstractReporter.this.afterScenario(event);
            }
        };
    }

    private EventHandler<TestRunFinished> getTestRunFinishedHandler() {
        return new EventHandler<TestRunFinished>(){

            public void receive(TestRunFinished event) {
                if (AbstractReporter.this.currentFeatureContext != null) {
                    AbstractReporter.this.handleEndOfFeature();
                }
                AbstractReporter.this.afterLaunch();
            }
        };
    }

    private EventHandler<EmbedEvent> getEmbedEventHandler() {
        return new EventHandler<EmbedEvent>(){

            public void receive(EmbedEvent event) {
                AbstractReporter.this.embedding(event.mimeType, event.data);
            }
        };
    }

    private EventHandler<WriteEvent> getWriteEventHandler() {
        return new EventHandler<WriteEvent>(){

            public void receive(WriteEvent event) {
                AbstractReporter.this.write(event.text);
            }
        };
    }

    private void handleStartOfFeature(TestCase testCase) {
        this.currentFeatureContext = new RunningContext.FeatureContext().processTestSourceReadEvent(testCase);
        this.beforeFeature();
    }

    private void handleEndOfFeature() {
        this.afterFeature();
    }

    private void handleStartOfTestCase(TestCaseStarted event) {
        TestCase testCase = event.testCase;
        if (this.currentFeatureContext != null && !testCase.getUri().equals(this.currentFeatureContext.getUri())) {
            this.handleEndOfFeature();
        }
        if (this.currentFeatureContext == null) {
            this.handleStartOfFeature(testCase);
        }
        if (!this.currentFeatureContext.getUri().equals(testCase.getUri())) {
            throw new IllegalStateException("Scenario URI does not match Feature URI.");
        }
        if (this.currentScenarioContext == null) {
            this.currentScenarioContext = this.currentFeatureContext.getScenarioContext(testCase);
        }
        this.beforeScenario();
    }

    private void handleTestStepStarted(TestStepStarted event) {
        TestStep testStep = event.testStep;
        if (testStep instanceof HookTestStep) {
            this.beforeHooks(this.isBefore(testStep));
        } else {
            if (this.currentScenarioContext.withBackground()) {
                this.currentScenarioContext.nextBackgroundStep();
            }
            this.beforeStep(testStep);
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof HookTestStep) {
            this.hookFinished(event.testStep, event.result, this.isBefore(event.testStep));
            this.afterHooks(this.isBefore(event.testStep));
        } else {
            this.afterStep(event.result);
        }
    }
}

