/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.Utils;
import cucumber.api.PickleStepTestStep;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.TestSourceRead;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableRow;
import gherkin.pickles.PickleTag;
import io.reactivex.Maybe;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class RunningContext {

    public static class ScenarioContext {
        private static Map<Integer, ArrayDeque<String>> outlineIterationsMap = new HashMap<Integer, ArrayDeque<String>>();
        private Maybe<String> id = null;
        private Background background;
        private ScenarioDefinition scenario;
        private Queue<Step> backgroundSteps = new ArrayDeque<Step>();
        private Map<Integer, Step> scenarioLocationMap = new HashMap<Integer, Step>();
        private Set<String> tags = new HashSet<String>();
        private TestCase testCase;
        private boolean hasBackground = false;

        ScenarioContext() {
        }

        ScenarioContext processScenario(ScenarioDefinition scenario) {
            this.scenario = scenario;
            for (Step step : scenario.getSteps()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
            return this;
        }

        void processBackground(Background background) {
            if (background != null) {
                this.background = background;
                this.hasBackground = true;
                this.backgroundSteps.addAll(background.getSteps());
                this.mapBackgroundSteps(background);
            }
        }

        void processScenarioOutline(ScenarioDefinition scenarioOutline) {
            if (this.isScenarioOutline(scenarioOutline) && !this.hasOutlineSteps()) {
                int num = 0;
                outlineIterationsMap.put(this.scenario.getLocation().getLine(), new ArrayDeque());
                for (Examples example : ((ScenarioOutline)scenarioOutline).getExamples()) {
                    num += example.getTableBody().size();
                }
                for (int i = 1; i <= num; ++i) {
                    outlineIterationsMap.get(this.scenario.getLocation().getLine()).add(" [" + i + "]");
                }
            }
        }

        void processTags(List<PickleTag> pickleTags) {
            this.tags = Utils.extractPickleTags(pickleTags);
        }

        void mapBackgroundSteps(Background background) {
            for (Step step : background.getSteps()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
        }

        String getName() {
            return this.scenario.getName();
        }

        String getKeyword() {
            return this.scenario.getKeyword();
        }

        int getLine() {
            if (this.isScenarioOutline(this.scenario)) {
                return this.testCase.getLine();
            }
            return this.scenario.getLocation().getLine();
        }

        Set<String> getTags() {
            return this.tags;
        }

        String getStepPrefix() {
            if (this.hasBackground() && this.withBackground()) {
                return this.background.getKeyword().toUpperCase() + ": ";
            }
            return "";
        }

        Step getStep(TestStep testStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            Step step = this.scenarioLocationMap.get(pickleStepTestStep.getStepLine());
            if (step != null) {
                return step;
            }
            throw new IllegalStateException(String.format("Trying to get step for unknown line in feature. Scenario: %s, line: %s", this.scenario.getName(), this.getLine()));
        }

        Maybe<String> getId() {
            return this.id;
        }

        void setId(Maybe<String> newId) {
            if (this.id != null) {
                throw new IllegalStateException("Attempting re-set scenario ID for unfinished scenario.");
            }
            this.id = newId;
        }

        void setTestCase(TestCase testCase) {
            this.testCase = testCase;
        }

        void nextBackgroundStep() {
            this.backgroundSteps.poll();
        }

        boolean isScenarioOutline(ScenarioDefinition scenario) {
            if (scenario != null) {
                return scenario instanceof ScenarioOutline;
            }
            return false;
        }

        boolean withBackground() {
            return !this.backgroundSteps.isEmpty();
        }

        boolean hasBackground() {
            return this.hasBackground && this.background != null;
        }

        boolean hasOutlineSteps() {
            return outlineIterationsMap.get(this.scenario.getLocation().getLine()) != null && !outlineIterationsMap.get(this.scenario.getLocation().getLine()).isEmpty();
        }

        String getOutlineIteration() {
            if (this.hasOutlineSteps()) {
                return outlineIterationsMap.get(this.scenario.getLocation().getLine()).poll();
            }
            return null;
        }
    }

    public static class FeatureContext {
        private static Map<String, TestSourceRead> pathToReadEventMap = new HashMap<String, TestSourceRead>();
        private String currentFeatureUri;
        private Maybe<String> currentFeatureId;
        private Feature currentFeature;
        private Set<String> tags = new HashSet<String>();

        FeatureContext() {
        }

        static void addTestSourceReadEvent(String path, TestSourceRead event) {
            pathToReadEventMap.put(path, event);
        }

        ScenarioContext getScenarioContext(TestCase testCase) {
            Object scenario = this.getScenario(testCase);
            ScenarioContext context = new ScenarioContext();
            context.processScenario((ScenarioDefinition)scenario);
            context.setTestCase(testCase);
            context.processBackground(this.getBackground());
            context.processScenarioOutline((ScenarioDefinition)scenario);
            context.processTags(testCase.getTags());
            return context;
        }

        FeatureContext processTestSourceReadEvent(TestCase testCase) {
            TestSourceRead event = pathToReadEventMap.get(testCase.getUri());
            this.currentFeature = this.getFeature(event.source);
            this.currentFeatureUri = event.uri;
            this.tags = Utils.extractTags(this.currentFeature.getTags());
            return this;
        }

        Feature getFeature(String source) {
            GherkinDocument gherkinDocument;
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            try {
                gherkinDocument = (GherkinDocument)parser.parse(source, (Parser.ITokenMatcher)matcher);
            }
            catch (ParserException e) {
                return null;
            }
            return gherkinDocument.getFeature();
        }

        Background getBackground() {
            ScenarioDefinition background = (ScenarioDefinition)this.getFeature().getChildren().get(0);
            if (background instanceof Background) {
                return (Background)background;
            }
            return null;
        }

        Feature getFeature() {
            return this.currentFeature;
        }

        Set<String> getTags() {
            return this.tags;
        }

        String getUri() {
            return this.currentFeatureUri;
        }

        Maybe<String> getFeatureId() {
            return this.currentFeatureId;
        }

        void setFeatureId(Maybe<String> featureId) {
            this.currentFeatureId = featureId;
        }

        <T extends ScenarioDefinition> T getScenario(TestCase testCase) {
            List featureScenarios = this.getFeature().getChildren();
            for (ScenarioDefinition scenario : featureScenarios) {
                if (scenario instanceof Background) continue;
                if (testCase.getLine() == scenario.getLocation().getLine() && testCase.getName().equals(scenario.getName())) {
                    return (T)scenario;
                }
                if (!(scenario instanceof ScenarioOutline)) continue;
                for (Examples example : ((ScenarioOutline)scenario).getExamples()) {
                    for (TableRow tableRow : example.getTableBody()) {
                        if (tableRow.getLocation().getLine() != testCase.getLine()) continue;
                        return (T)scenario;
                    }
                }
            }
            throw new IllegalStateException("Scenario can't be null!");
        }
    }
}

