/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.AbstractReporter;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import cucumber.api.Result;
import cucumber.api.TestStep;
import gherkin.ast.Step;
import io.reactivex.Maybe;
import java.util.Calendar;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;

public class ScenarioReporter
extends AbstractReporter {
    private static final String SEPARATOR = "-------------------------";
    protected Supplier<Maybe<String>> rootSuiteId;

    @Override
    protected void beforeLaunch() {
        super.beforeLaunch();
        this.startRootItem();
    }

    @Override
    protected void beforeStep(TestStep testStep) {
        Step step = this.currentScenarioContext.getStep(testStep);
        String decoratedStepName = this.decorateMessage(Utils.buildNodeName(this.currentScenarioContext.getStepPrefix(), step.getKeyword(), Utils.getStepName(testStep), " "));
        String multilineArg = Utils.buildMultilineArgument(testStep);
        Utils.sendLog(decoratedStepName + multilineArg, "INFO", null);
    }

    @Override
    protected void afterStep(Result result) {
        this.reportResult(result, this.decorateMessage("STEP " + result.getStatus().toString().toUpperCase()));
    }

    @Override
    protected void beforeHooks(Boolean isBefore) {
    }

    @Override
    protected void afterHooks(Boolean isBefore) {
    }

    @Override
    protected void hookFinished(TestStep step, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "@Before" : "@After") + "\n" + step.getCodeLocation());
    }

    @Override
    protected String getFeatureTestItemType() {
        return "TEST";
    }

    @Override
    protected String getScenarioTestItemType() {
        return "STEP";
    }

    @Override
    protected Maybe<String> getRootItemId() {
        return (Maybe)this.rootSuiteId.get();
    }

    @Override
    protected void afterLaunch() {
        this.finishRootItem();
        super.afterLaunch();
    }

    protected void finishRootItem() {
        Utils.finishTestItem((Launch)this.RP.get(), (Maybe<String>)((Maybe)this.rootSuiteId.get()));
        this.rootSuiteId = null;
    }

    protected void startRootItem() {
        this.rootSuiteId = Suppliers.memoize((Supplier)new Supplier<Maybe<String>>(){

            public Maybe<String> get() {
                StartTestItemRQ rq = new StartTestItemRQ();
                rq.setName("Root User Story");
                rq.setStartTime(Calendar.getInstance().getTime());
                rq.setType("STORY");
                return ((Launch)ScenarioReporter.this.RP.get()).startTestItem(rq);
            }
        });
    }

    private String decorateMessage(String message) {
        return SEPARATOR + message + SEPARATOR;
    }
}

