/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.cucumber.AbstractReporter;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import cucumber.api.Result;
import cucumber.api.TestStep;
import gherkin.ast.Step;
import io.reactivex.Maybe;
import java.util.Calendar;

public class StepReporter
extends AbstractReporter {
    protected Maybe<String> currentStepId = null;
    protected Maybe<String> hookStepId = null;
    protected String hookStatus = null;

    @Override
    protected Maybe<String> getRootItemId() {
        return null;
    }

    @Override
    protected void beforeStep(TestStep testStep) {
        Step step = this.currentScenarioContext.getStep(testStep);
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildNodeName(this.currentScenarioContext.getStepPrefix(), step.getKeyword(), Utils.getStepName(testStep), " "));
        rq.setDescription(Utils.buildMultilineArgument(testStep));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        this.currentStepId = ((Launch)this.RP.get()).startTestItem(this.currentScenarioContext.getId(), rq);
    }

    @Override
    protected void afterStep(Result result) {
        this.reportResult(result, null);
        Utils.finishTestItem((Launch)this.RP.get(), this.currentStepId, result.getStatus().toString().toUpperCase());
        this.currentStepId = null;
    }

    @Override
    protected void beforeHooks(Boolean isBefore) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(isBefore != false ? "Before hooks" : "After hooks");
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType(isBefore != false ? "BEFORE_TEST" : "AFTER_TEST");
        this.hookStepId = ((Launch)this.RP.get()).startTestItem(this.currentScenarioContext.getId(), rq);
        this.hookStatus = "PASSED";
    }

    @Override
    protected void afterHooks(Boolean isBefore) {
        Utils.finishTestItem((Launch)this.RP.get(), this.hookStepId, this.hookStatus);
        this.hookStepId = null;
    }

    @Override
    protected void hookFinished(TestStep step, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + step.getCodeLocation());
        this.hookStatus = result.getStatus().toString();
    }

    @Override
    protected String getFeatureTestItemType() {
        return "SUITE";
    }

    @Override
    protected String getScenarioTestItemType() {
        return "SCENARIO";
    }
}

