/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.cucumber.RunningContext;
import com.epam.reportportal.cucumber.Utils;
import com.epam.reportportal.cucumber.util.ItemTreeUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.ParameterUtils;
import com.epam.reportportal.utils.TestCaseIdUtils;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.http.ContentType;
import com.epam.reportportal.utils.markdown.MarkdownUtils;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import cucumber.api.Argument;
import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.ast.Feature;
import gherkin.ast.Step;
import gherkin.ast.Tag;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import io.reactivex.Maybe;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporter
implements ConcurrentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReporter.class);
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    private static final String STEP_DEFINITION_FIELD_NAME = "stepDefinition";
    private static final String GET_LOCATION_METHOD_NAME = "getLocation";
    private static final String METHOD_OPENING_BRACKET = "(";
    private static final String FILE_PREFIX = "file:";
    private static final String HOOK_ = "Hook: ";
    private static final String DOCSTRING_DECORATOR = "\n\"\"\"\n";
    public static final TestItemTree ITEM_TREE = new TestItemTree();
    private static volatile ReportPortal REPORT_PORTAL = ReportPortal.builder().build();
    protected Supplier<Launch> launch;
    static final String COLON_INFIX = ": ";
    private static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    private final Map<String, RunningContext.FeatureContext> currentFeatureContextMap = new ConcurrentHashMap<String, RunningContext.FeatureContext>();
    private final Map<Pair<Integer, String>, RunningContext.ScenarioContext> currentScenarioContextMap = new ConcurrentHashMap<Pair<Integer, String>, RunningContext.ScenarioContext>();
    private final ThreadLocal<RunningContext.ScenarioContext> currentScenarioContext = new ThreadLocal();
    private final Map<String, Date> featureEndTime = new ConcurrentHashMap<String, Date>();

    public static ReportPortal getReportPortal() {
        return REPORT_PORTAL;
    }

    protected static void setReportPortal(ReportPortal reportPortal) {
        REPORT_PORTAL = reportPortal;
    }

    protected RunningContext.ScenarioContext getCurrentScenarioContext() {
        return this.currentScenarioContext.get();
    }

    protected void beforeLaunch() {
        this.startLaunch();
        Maybe launchId = this.launch.get().start();
        ITEM_TREE.setLaunchId(launchId);
    }

    protected ReportPortal buildReportPortal() {
        return ReportPortal.builder().build();
    }

    protected void afterLaunch() {
        FinishExecutionRQ finishLaunchRq = new FinishExecutionRQ();
        finishLaunchRq.setEndTime(Calendar.getInstance().getTime());
        this.launch.get().finish(finishLaunchRq);
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nonnull TestStep testStep, @Nullable String codeRef) {
        Object definitionMatch = Utils.getDefinitionMatch(testStep);
        List arguments = ((PickleStepTestStep)testStep).getDefinitionArgument();
        if (definitionMatch != null) {
            try {
                Method method = Utils.retrieveMethod(definitionMatch);
                return TestCaseIdUtils.getTestCaseId((TestCaseId)method.getAnnotation(TestCaseId.class), (Executable)method, (String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.getTestCaseId(codeRef, arguments);
    }

    @Nullable
    protected TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Argument> arguments) {
        return TestCaseIdUtils.getTestCaseId((String)codeRef, Utils.ARGUMENTS_TRANSFORM.apply(arguments));
    }

    protected StartTestItemRQ buildStartScenarioRequest(TestCase testCase, String name, String uri, int line) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(name);
        rq.setDescription(this.getDescription(testCase, uri));
        String codeRef = this.getCodeRef(uri, line);
        rq.setCodeRef(codeRef);
        rq.setAttributes(this.extractPickleTags(testCase.getTags()));
        rq.setStartTime(Calendar.getInstance().getTime());
        String type = this.getScenarioTestItemType();
        rq.setType(type);
        if ("STEP".equals(type)) {
            rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(codeRef, null)).map(TestCaseIdEntry::getId).orElse(null));
        }
        return rq;
    }

    @Nonnull
    protected Maybe<String> startScenario(@Nonnull Maybe<String> featureId, @Nonnull StartTestItemRQ startScenarioRq) {
        return this.launch.get().startTestItem(featureId, startScenarioRq);
    }

    private void addToTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> suiteLeaf.getChildItems().put(ItemTreeUtils.createKey(scenarioContext.getLine()), TestItemTree.createTestItemLeaf(scenarioContext.getId())));
    }

    protected void beforeScenario(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        String scenarioName = Utils.buildName(scenarioContext.getKeyword(), COLON_INFIX, scenarioContext.getTestCase().getName());
        Maybe<String> id = this.startScenario(featureContext.getFeatureId(), this.buildStartScenarioRequest(scenarioContext.getTestCase(), scenarioName, featureContext.getUri(), scenarioContext.getLine()));
        scenarioContext.setId(id);
        if (this.launch.get().getParameters().isCallbackReportingEnabled()) {
            this.addToTree(featureContext, scenarioContext);
        }
    }

    @Nullable
    protected ItemStatus mapItemStatus(@Nullable Result.Type status) {
        if (status == null) {
            return null;
        }
        if (Utils.STATUS_MAPPING.get(status) == null) {
            LOGGER.error(String.format("Unable to find direct mapping between Cucumber and ReportPortal for TestItem with status: '%s'.", status));
            return ItemStatus.SKIPPED;
        }
        return Utils.STATUS_MAPPING.get(status);
    }

    @Nonnull
    protected FinishTestItemRQ buildFinishTestItemRequest(@Nonnull Maybe<String> itemId, @Nullable Date finishTime, @Nullable ItemStatus status) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        Optional.ofNullable(status).ifPresent(s -> rq.setStatus(s.name()));
        rq.setEndTime(Optional.ofNullable(finishTime).orElse(Calendar.getInstance().getTime()));
        return rq;
    }

    protected Date finishTestItem(Maybe<String> itemId, Result.Type status) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return null;
        }
        FinishTestItemRQ rq = this.buildFinishTestItemRequest(itemId, null, this.mapItemStatus(status));
        this.launch.get().finishTestItem(itemId, rq);
        return rq.getEndTime();
    }

    protected void finishTestItem(Maybe<String> itemId) {
        this.finishTestItem(itemId, null);
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext, RunningContext.ScenarioContext scenarioContext) {
        ItemTreeUtils.retrieveLeaf(featureContext.getUri(), ITEM_TREE).ifPresent(suiteLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)suiteLeaf.getChildItems().remove(ItemTreeUtils.createKey(scenarioContext.getLine()));
        });
    }

    protected void afterScenario(TestCaseFinished event) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        String featureUri = context.getFeatureUri();
        this.currentScenarioContextMap.remove(Pair.of((Object)context.getLine(), (Object)featureUri));
        Date endTime = this.finishTestItem(context.getId(), event.result.getStatus());
        this.featureEndTime.put(featureUri, endTime);
        this.currentScenarioContext.remove();
        this.removeFromTree(this.currentFeatureContextMap.get(context.getFeatureUri()), context);
    }

    protected void startLaunch() {
        this.launch = new MemoizingSupplier((Supplier)new Supplier<Launch>(){
            private final Date startTime = Calendar.getInstance().getTime();

            @Override
            public Launch get() {
                ReportPortal reportPortal = AbstractReporter.this.buildReportPortal();
                ListenerParameters parameters = reportPortal.getParameters();
                StartLaunchRQ rq = new StartLaunchRQ();
                rq.setName(parameters.getLaunchName());
                rq.setStartTime(this.startTime);
                rq.setMode(parameters.getLaunchRunningMode());
                HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>(parameters.getAttributes());
                rq.setAttributes(attributes);
                attributes.addAll(SystemAttributesExtractor.extract((String)AbstractReporter.AGENT_PROPERTIES_FILE, (ClassLoader)AbstractReporter.class.getClassLoader()));
                rq.setDescription(parameters.getDescription());
                rq.setRerun(parameters.isRerun());
                if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
                    rq.setRerunOf(parameters.getRerunOf());
                }
                if (null != parameters.getSkippedAnIssue()) {
                    ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
                    skippedIssueAttribute.setKey(AbstractReporter.SKIPPED_ISSUE_KEY);
                    skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
                    skippedIssueAttribute.setSystem(true);
                    attributes.add(skippedIssueAttribute);
                }
                return reportPortal.newLaunch(rq);
            }
        });
    }

    @Nullable
    protected String getStepName(@Nonnull TestStep testStep) {
        return testStep instanceof HookTestStep ? HOOK_ + ((HookTestStep)testStep).getHookType().toString() : ((PickleStepTestStep)testStep).getPickleStep().getText();
    }

    protected StartTestItemRQ buildStartStepRequest(TestStep testStep, String stepPrefix, String keyword) {
        StartTestItemRQ rq = new StartTestItemRQ();
        rq.setName(Utils.buildName(stepPrefix, keyword, this.getStepName(testStep)));
        rq.setDescription(this.buildMultilineArgument(testStep));
        rq.setStartTime(Calendar.getInstance().getTime());
        rq.setType("STEP");
        String codeRef = this.getCodeRef(testStep);
        rq.setParameters(this.getParameters(codeRef, testStep));
        rq.setCodeRef(codeRef);
        rq.setTestCaseId((String)Optional.ofNullable(this.getTestCaseId(testStep, codeRef)).map(TestCaseIdEntry::getId).orElse(null));
        rq.setAttributes(this.getAttributes(testStep));
        return rq;
    }

    @Nonnull
    protected Maybe<String> startStep(@Nonnull Maybe<String> scenarioId, @Nonnull StartTestItemRQ startStepRq) {
        return this.launch.get().startTestItem(scenarioId, startStepRq);
    }

    protected void beforeStep(TestStep testStep) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        Step step = context.getStep(testStep);
        StartTestItemRQ rq = this.buildStartStepRequest(testStep, context.getStepPrefix(), step.getKeyword());
        Maybe<String> stepId = this.startStep(context.getId(), rq);
        context.setCurrentStepId(stepId);
        String stepText = step.getText();
        context.setCurrentText(stepText);
        if (this.launch.get().getParameters().isCallbackReportingEnabled()) {
            this.addToTree(context, stepText, stepId);
        }
    }

    protected void afterStep(Result result) {
        this.reportResult(result, null);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getCurrentStepId(), result.getStatus());
        context.setCurrentStepId(null);
    }

    protected StartTestItemRQ buildStartHookRequest(HookType hookType) {
        StartTestItemRQ rq = new StartTestItemRQ();
        Pair<String, String> typeName = this.getHookTypeAndName(hookType);
        rq.setType((String)typeName.getKey());
        rq.setName((String)typeName.getValue());
        rq.setStartTime(Calendar.getInstance().getTime());
        return rq;
    }

    @Nonnull
    protected Maybe<String> startHook(@Nonnull Maybe<String> parentId, @Nonnull StartTestItemRQ rq) {
        return this.launch.get().startTestItem(parentId, rq);
    }

    protected void beforeHooks(HookType hookType) {
        StartTestItemRQ rq = this.buildStartHookRequest(hookType);
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        context.setHookStepId(this.startHook(context.getId(), rq));
        context.setHookStatus(Result.Type.PASSED);
    }

    protected void afterHooks(HookType hookType) {
        RunningContext.ScenarioContext context = this.getCurrentScenarioContext();
        this.finishTestItem(context.getHookStepId(), context.getHookStatus());
        context.setHookStepId(null);
        if (hookType == HookType.AfterStep) {
            this.removeFromTree(context, context.getCurrentText());
            context.setCurrentText(null);
        }
    }

    protected void hookFinished(HookTestStep step, Result result, Boolean isBefore) {
        this.reportResult(result, (isBefore != false ? "Before" : "After") + " hook: " + step.getCodeLocation());
        this.getCurrentScenarioContext().setHookStatus(result.getStatus());
    }

    @Nonnull
    protected abstract String getFeatureTestItemType();

    @Nonnull
    protected abstract String getScenarioTestItemType();

    protected void reportResult(Result result, String message) {
        String errorMessage;
        String level = this.mapLevel(result.getStatus());
        if (message != null) {
            this.sendLog(message, level);
        }
        if ((errorMessage = result.getErrorMessage()) != null) {
            this.sendLog(errorMessage, level);
        } else if (result.getError() != null) {
            this.sendLog(ExceptionUtils.getStackTrace((Throwable)result.getError()), level);
        }
    }

    @Nullable
    private static String getDataType(@Nonnull byte[] data, @Nullable String name) {
        try {
            return MimeTypeDetector.detect((ByteSource)ByteSource.wrap((byte[])data), (String)name);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to detect MIME type", (Throwable)e);
            return null;
        }
    }

    protected void embedding(@Nullable String name, String mimeType, byte[] data) {
        String type = Optional.ofNullable(mimeType).filter(ContentType::isValidType).orElseGet(() -> AbstractReporter.getDataType(data, name));
        String attachmentName = Optional.ofNullable(name).filter(m -> !m.isEmpty()).orElseGet(() -> Optional.ofNullable(type).map(t -> t.substring(0, t.indexOf("/"))).orElse(""));
        ReportPortal.emitLog((ReportPortalMessage)new ReportPortalMessage(ByteSource.wrap((byte[])data), type, attachmentName), (String)"UNKNOWN", (Date)Calendar.getInstance().getTime());
    }

    protected void sendLog(String message) {
        this.sendLog(message, "INFO");
    }

    protected void sendLog(String message, String level) {
        ReportPortal.emitLog((String)message, (String)level, (Date)Calendar.getInstance().getTime());
    }

    private boolean isBefore(TestStep step) {
        return HookType.Before == ((HookTestStep)step).getHookType();
    }

    @Nonnull
    protected abstract Optional<Maybe<String>> getRootItemId();

    protected void finishFeature(Maybe<String> itemId, Date dateTime) {
        if (itemId == null) {
            LOGGER.error("BUG: Trying to finish unspecified test item.");
            return;
        }
        FinishTestItemRQ rq = this.buildFinishTestItemRequest(itemId, dateTime, null);
        this.launch.get().finishTestItem(itemId, rq);
    }

    private void removeFromTree(RunningContext.FeatureContext featureContext) {
        ITEM_TREE.getTestItems().remove(ItemTreeUtils.createKey(featureContext.getUri()));
    }

    protected void handleEndOfFeature() {
        this.currentFeatureContextMap.values().forEach(f -> {
            Date featureCompletionDateTime = this.featureEndTime.get(f.getUri());
            this.finishFeature(f.getFeatureId(), featureCompletionDateTime);
            this.removeFromTree((RunningContext.FeatureContext)f);
        });
        this.currentFeatureContextMap.clear();
    }

    protected EventHandler<TestRunStarted> getTestRunStartedHandler() {
        return event -> this.beforeLaunch();
    }

    protected EventHandler<TestSourceRead> getTestSourceReadHandler() {
        return event -> RunningContext.FeatureContext.addTestSourceReadEvent(event.uri, event);
    }

    protected EventHandler<TestCaseStarted> getTestCaseStartedHandler() {
        return this::handleStartOfTestCase;
    }

    protected EventHandler<TestStepStarted> getTestStepStartedHandler() {
        return this::handleTestStepStarted;
    }

    protected EventHandler<TestStepFinished> getTestStepFinishedHandler() {
        return this::handleTestStepFinished;
    }

    protected EventHandler<TestCaseFinished> getTestCaseFinishedHandler() {
        return this::afterScenario;
    }

    protected EventHandler<TestRunFinished> getTestRunFinishedHandler() {
        return event -> {
            this.handleEndOfFeature();
            this.afterLaunch();
        };
    }

    protected EventHandler<EmbedEvent> getEmbedEventHandler() {
        return event -> this.embedding(event.name, event.mimeType, event.data);
    }

    protected EventHandler<WriteEvent> getWriteEventHandler() {
        return event -> this.sendLog(event.text);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.getTestRunStartedHandler());
        publisher.registerHandlerFor(TestSourceRead.class, this.getTestSourceReadHandler());
        publisher.registerHandlerFor(TestCaseStarted.class, this.getTestCaseStartedHandler());
        publisher.registerHandlerFor(TestStepStarted.class, this.getTestStepStartedHandler());
        publisher.registerHandlerFor(TestStepFinished.class, this.getTestStepFinishedHandler());
        publisher.registerHandlerFor(TestCaseFinished.class, this.getTestCaseFinishedHandler());
        publisher.registerHandlerFor(TestRunFinished.class, this.getTestRunFinishedHandler());
        publisher.registerHandlerFor(EmbedEvent.class, this.getEmbedEventHandler());
        publisher.registerHandlerFor(WriteEvent.class, this.getWriteEventHandler());
    }

    protected StartTestItemRQ buildStartFeatureRequest(Feature feature, String uri) {
        String featureKeyword = feature.getKeyword();
        String featureName = feature.getName();
        StartTestItemRQ startFeatureRq = new StartTestItemRQ();
        startFeatureRq.setDescription(this.getDescription(feature, uri));
        startFeatureRq.setCodeRef(this.getCodeRef(uri, 0));
        startFeatureRq.setName(Utils.buildName(featureKeyword, COLON_INFIX, featureName));
        startFeatureRq.setAttributes(this.extractAttributes(feature.getTags()));
        startFeatureRq.setStartTime(Calendar.getInstance().getTime());
        startFeatureRq.setType(this.getFeatureTestItemType());
        return startFeatureRq;
    }

    @Nonnull
    protected Maybe<String> startFeature(@Nonnull StartTestItemRQ startFeatureRq) {
        Optional<Maybe<String>> root = this.getRootItemId();
        return root.map(r -> this.launch.get().startTestItem(r, startFeatureRq)).orElseGet(() -> this.launch.get().startTestItem(startFeatureRq));
    }

    private void addToTree(RunningContext.FeatureContext context) {
        ITEM_TREE.getTestItems().put(ItemTreeUtils.createKey(context.getUri()), TestItemTree.createTestItemLeaf(context.getFeatureId()));
    }

    protected void handleStartOfTestCase(TestCaseStarted event) {
        TestCase testCase = event.testCase;
        RunningContext.FeatureContext newFeatureContext = new RunningContext.FeatureContext(testCase);
        String featureUri = newFeatureContext.getUri();
        RunningContext.FeatureContext featureContext = this.currentFeatureContextMap.computeIfAbsent(featureUri, u -> {
            this.getRootItemId();
            newFeatureContext.setFeatureId(this.startFeature(this.buildStartFeatureRequest(newFeatureContext.getFeature(), featureUri)));
            if (this.launch.get().getParameters().isCallbackReportingEnabled()) {
                this.addToTree(newFeatureContext);
            }
            return newFeatureContext;
        });
        if (!featureContext.getUri().equals(testCase.getUri())) {
            throw new IllegalStateException("Scenario URI does not match Feature URI.");
        }
        RunningContext.ScenarioContext newScenarioContext = featureContext.getScenarioContext(testCase);
        Pair scenarioLineFeatureURI = Pair.of((Object)newScenarioContext.getLine(), (Object)featureContext.getUri());
        RunningContext.ScenarioContext scenarioContext = this.currentScenarioContextMap.computeIfAbsent((Pair<Integer, String>)scenarioLineFeatureURI, k -> {
            this.currentScenarioContext.set(newScenarioContext);
            return newScenarioContext;
        });
        this.beforeScenario(featureContext, scenarioContext);
    }

    protected void handleTestStepStarted(TestStepStarted event) {
        TestStep testStep = event.testStep;
        if (testStep instanceof HookTestStep) {
            this.beforeHooks(((HookTestStep)testStep).getHookType());
        } else {
            if (this.getCurrentScenarioContext().withBackground()) {
                this.getCurrentScenarioContext().nextBackgroundStep();
            }
            this.beforeStep(testStep);
        }
    }

    protected void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof HookTestStep) {
            HookTestStep testStep = (HookTestStep)event.testStep;
            this.hookFinished(testStep, event.result, this.isBefore(event.testStep));
            this.afterHooks(testStep.getHookType());
        } else {
            this.afterStep(event.result);
        }
    }

    protected void addToTree(RunningContext.ScenarioContext scenarioContext, String text, Maybe<String> stepId) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> scenarioLeaf.getChildItems().put(ItemTreeUtils.createKey(text), TestItemTree.createTestItemLeaf((Maybe)stepId)));
    }

    protected void removeFromTree(RunningContext.ScenarioContext scenarioContext, String text) {
        ItemTreeUtils.retrieveLeaf(scenarioContext.getFeatureUri(), scenarioContext.getLine(), ITEM_TREE).ifPresent(scenarioLeaf -> {
            TestItemTree.TestItemLeaf cfr_ignored_0 = (TestItemTree.TestItemLeaf)scenarioLeaf.getChildItems().remove(ItemTreeUtils.createKey(text));
        });
    }

    @Nonnull
    protected String mapLevel(@Nullable Result.Type cukesStatus) {
        if (cukesStatus == null) {
            return "ERROR";
        }
        String level = Utils.LOG_LEVEL_MAPPING.get(cukesStatus);
        return null == level ? "ERROR" : level;
    }

    @Nonnull
    protected String formatDataTable(@Nonnull List<List<String>> table) {
        return MarkdownUtils.formatDataTable(table);
    }

    @Nonnull
    protected String buildMultilineArgument(@Nonnull TestStep step) {
        List table = null;
        String docString = null;
        PickleStepTestStep pickleStep = (PickleStepTestStep)step;
        if (!pickleStep.getStepArgument().isEmpty()) {
            gherkin.pickles.Argument argument = (gherkin.pickles.Argument)pickleStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                docString = ((PickleString)argument).getContent();
            } else if (argument instanceof PickleTable) {
                table = ((PickleTable)argument).getRows().stream().map(r -> r.getCells().stream().map(PickleCell::getValue).collect(Collectors.toList())).collect(Collectors.toList());
            }
        }
        StringBuilder marg = new StringBuilder();
        if (table != null) {
            marg.append(this.formatDataTable(table));
        }
        if (docString != null) {
            marg.append(DOCSTRING_DECORATOR).append(docString).append(DOCSTRING_DECORATOR);
        }
        return marg.toString();
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractPickleTags(@Nonnull List<PickleTag> tags) {
        return tags.stream().map(t -> new ItemAttributesRQ(null, t.getName())).collect(Collectors.toSet());
    }

    @Nonnull
    protected Set<ItemAttributesRQ> extractAttributes(@Nonnull List<Tag> tags) {
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>();
        for (Tag tag : tags) {
            attributes.add(new ItemAttributesRQ(null, tag.getName()));
        }
        return attributes;
    }

    @Nullable
    protected Set<ItemAttributesRQ> getAttributes(@Nonnull TestStep testStep) {
        Object definitionMatch = Utils.getDefinitionMatch(testStep);
        if (definitionMatch != null) {
            try {
                Method method = Utils.retrieveMethod(definitionMatch);
                Attributes attributesAnnotation = method.getAnnotation(Attributes.class);
                if (attributesAnnotation != null) {
                    return AttributeParser.retrieveAttributes((Attributes)attributesAnnotation);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    protected String getCodeRef(@Nonnull TestStep testStep) {
        return Optional.ofNullable(Utils.getDefinitionMatch(testStep)).map(m -> (StepDefinitionMatch)m).flatMap(stepDefinitionMatch -> {
            try {
                Field stepDefinitionField = stepDefinitionMatch.getClass().getDeclaredField(STEP_DEFINITION_FIELD_NAME);
                stepDefinitionField.setAccessible(true);
                Object javaStepDefinition = stepDefinitionField.get(stepDefinitionMatch);
                Method getLocationMethod = javaStepDefinition.getClass().getDeclaredMethod(GET_LOCATION_METHOD_NAME, Boolean.TYPE);
                getLocationMethod.setAccessible(true);
                return Optional.of(String.valueOf(getLocationMethod.invoke(javaStepDefinition, true))).filter(r -> !r.isEmpty()).map(r -> {
                    int openingBracketIndex = r.indexOf(METHOD_OPENING_BRACKET);
                    if (openingBracketIndex > 0) {
                        return r.substring(0, r.indexOf(METHOD_OPENING_BRACKET));
                    }
                    return r;
                });
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return Optional.empty();
            }
        }).orElseGet(() -> ((TestStep)testStep).getCodeLocation());
    }

    @Nonnull
    protected String getCodeRef(@Nonnull String uri, int line) {
        String myUri = uri.startsWith(FILE_PREFIX) ? uri.substring(FILE_PREFIX.length()) : uri;
        return myUri + ":" + line;
    }

    @Nonnull
    protected List<ParameterResource> getParameters(@Nullable String codeRef, @Nonnull TestStep testStep) {
        if (!(testStep instanceof PickleStepTestStep)) {
            return Collections.emptyList();
        }
        PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
        List arguments = pickleStepTestStep.getDefinitionArgument();
        List params = Optional.ofNullable(arguments).map(a -> IntStream.range(0, a.size()).mapToObj(i -> Pair.of((Object)("arg" + i), (Object)((Argument)a.get(i)).getValue())).collect(Collectors.toList())).orElse(new ArrayList());
        params.addAll(Optional.ofNullable(pickleStepTestStep.getPickleStep().getArgument()).map(a -> IntStream.range(0, a.size()).mapToObj(i -> {
            gherkin.pickles.Argument arg = (gherkin.pickles.Argument)a.get(i);
            String value = arg instanceof PickleString ? ((PickleString)arg).getContent() : (arg instanceof PickleTable ? this.formatDataTable(((PickleTable)arg).getRows().stream().map(r -> r.getCells().stream().map(PickleCell::getValue).collect(Collectors.toList())).collect(Collectors.toList())) : arg.toString());
            return Pair.of((Object)("arg" + i), (Object)value);
        }).collect(Collectors.toList())).orElse(Collections.emptyList()));
        return ParameterUtils.getParameters((String)codeRef, (List)params);
    }

    @Nonnull
    protected String getDescription(@Nonnull TestCase testCase, @Nonnull String uri) {
        return uri;
    }

    @Nonnull
    protected String getDescription(@Nonnull Feature feature, @Nonnull String uri) {
        return uri;
    }

    @Nonnull
    protected Pair<String, String> getHookTypeAndName(@Nonnull HookType hookType) {
        switch (hookType) {
            case Before: {
                return Pair.of((Object)ItemType.BEFORE_TEST.name(), (Object)"Before hooks");
            }
            case After: {
                return Pair.of((Object)ItemType.AFTER_TEST.name(), (Object)"After hooks");
            }
            case AfterStep: {
                return Pair.of((Object)ItemType.AFTER_METHOD.name(), (Object)"After step");
            }
            case BeforeStep: {
                return Pair.of((Object)ItemType.BEFORE_METHOD.name(), (Object)"Before step");
            }
        }
        return Pair.of((Object)ItemType.TEST.name(), (Object)"Hook");
    }
}

