/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import io.cucumber.core.internal.gherkin.AstBuilder;
import io.cucumber.core.internal.gherkin.Parser;
import io.cucumber.core.internal.gherkin.ParserException;
import io.cucumber.core.internal.gherkin.TokenMatcher;
import io.cucumber.core.internal.gherkin.ast.Background;
import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Step;
import io.cucumber.core.internal.gherkin.ast.TableRow;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.reactivex.Maybe;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RunningContext {
    private RunningContext() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static class ScenarioContext {
        private static final Map<ScenarioDefinition, List<Integer>> scenarioOutlineMap = new ConcurrentHashMap<ScenarioDefinition, List<Integer>>();
        private final Queue<Step> backgroundSteps = new ArrayDeque<Step>();
        private final Map<Integer, Step> scenarioLocationMap = new HashMap<Integer, Step>();
        private Maybe<String> currentStepId;
        private Maybe<String> hookStepId;
        private Status hookStatus;
        private Maybe<String> id;
        private Background background;
        private ScenarioDefinition scenario;
        private TestCase testCase;
        private boolean hasBackground = false;
        private String outlineIteration;
        private URI uri;
        private String text;

        public void processScenario(ScenarioDefinition scenario) {
            this.scenario = scenario;
            for (Step step : scenario.getSteps()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
        }

        public void processBackground(Background background) {
            if (background != null) {
                this.background = background;
                this.hasBackground = true;
                this.backgroundSteps.addAll(background.getSteps());
                this.mapBackgroundSteps(background);
            }
        }

        public void processScenarioOutline(ScenarioDefinition scenarioOutline) {
            if (this.isScenarioOutline(scenarioOutline)) {
                scenarioOutlineMap.computeIfAbsent(scenarioOutline, k -> ((ScenarioOutline)scenarioOutline).getExamples().stream().flatMap(e -> e.getTableBody().stream()).map(r -> r.getLocation().getLine()).collect(Collectors.toList()));
                int iterationIdx = IntStream.range(0, scenarioOutlineMap.get(scenarioOutline).size()).filter(i -> this.getLine() == scenarioOutlineMap.get(scenarioOutline).get(i).intValue()).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No outline iteration number found for scenario %s:%s", this.uri, this.getLine())));
                this.outlineIteration = String.format("[%d]", iterationIdx + 1);
            }
        }

        public void mapBackgroundSteps(Background background) {
            for (Step step : background.getSteps()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
        }

        public String getName() {
            return this.scenario.getName();
        }

        public String getKeyword() {
            return this.scenario.getKeyword();
        }

        public int getLine() {
            return this.isScenarioOutline(this.scenario) ? this.testCase.getLine().intValue() : this.scenario.getLocation().getLine();
        }

        public String getStepPrefix() {
            return this.hasBackground() && this.withBackground() ? this.background.getKeyword().toUpperCase() + ": " : "";
        }

        public Step getStep(TestStep testStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            Step step = this.scenarioLocationMap.get(pickleStepTestStep.getStep().getLine());
            if (step != null) {
                return step;
            }
            throw new IllegalStateException(String.format("Trying to get step for unknown line in feature. Scenario: %s, line: %s", this.scenario.getName(), this.getLine()));
        }

        public Maybe<String> getId() {
            return this.id;
        }

        public void setId(Maybe<String> newId) {
            if (this.id != null) {
                throw new IllegalStateException("Attempting re-set scenario ID for unfinished scenario: " + this.getName());
            }
            this.id = newId;
        }

        public void setTestCase(TestCase testCase) {
            this.testCase = testCase;
        }

        public void nextBackgroundStep() {
            this.backgroundSteps.poll();
        }

        public boolean isScenarioOutline(ScenarioDefinition scenario) {
            return scenario instanceof ScenarioOutline;
        }

        public boolean withBackground() {
            return !this.backgroundSteps.isEmpty();
        }

        public boolean hasBackground() {
            return this.hasBackground && this.background != null;
        }

        public String getOutlineIteration() {
            return this.outlineIteration;
        }

        public Maybe<String> getCurrentStepId() {
            return this.currentStepId;
        }

        public void setCurrentStepId(Maybe<String> currentStepId) {
            this.currentStepId = currentStepId;
        }

        public Maybe<String> getHookStepId() {
            return this.hookStepId;
        }

        public void setHookStepId(Maybe<String> hookStepId) {
            this.hookStepId = hookStepId;
        }

        public Status getHookStatus() {
            return this.hookStatus;
        }

        public void setHookStatus(Status hookStatus) {
            this.hookStatus = hookStatus;
        }

        public void setFeatureUri(URI featureUri) {
            this.uri = featureUri;
        }

        public URI getFeatureUri() {
            return this.uri;
        }

        public void setCurrentText(String stepText) {
            this.text = stepText;
        }

        public String getCurrentText() {
            return this.text;
        }

        public TestCase getTestCase() {
            return this.testCase;
        }
    }

    public static class FeatureContext {
        private static final Map<URI, TestSourceRead> PATH_TO_READ_EVENT_MAP = new ConcurrentHashMap<URI, TestSourceRead>();
        private final URI currentFeatureUri;
        private final Feature currentFeature;
        private Maybe<String> currentFeatureId;

        public FeatureContext(TestCase testCase) {
            TestSourceRead event = PATH_TO_READ_EVENT_MAP.get(testCase.getUri());
            this.currentFeature = this.getFeature(event.getSource());
            this.currentFeatureUri = event.getUri();
        }

        public static void addTestSourceReadEvent(URI uri, TestSourceRead event) {
            PATH_TO_READ_EVENT_MAP.put(uri, event);
        }

        public ScenarioContext getScenarioContext(TestCase testCase) {
            Object scenario = this.getScenario(testCase);
            ScenarioContext context = new ScenarioContext();
            context.processScenario((ScenarioDefinition)scenario);
            context.setTestCase(testCase);
            context.processBackground(this.getBackground());
            context.processScenarioOutline((ScenarioDefinition)scenario);
            context.setFeatureUri(this.getUri());
            return context;
        }

        public Feature getFeature(String source) {
            GherkinDocument gherkinDocument;
            Parser parser = new Parser((Parser.Builder)new AstBuilder());
            TokenMatcher matcher = new TokenMatcher();
            try {
                gherkinDocument = (GherkinDocument)parser.parse(source, (Parser.ITokenMatcher)matcher);
            }
            catch (ParserException e) {
                return null;
            }
            return gherkinDocument.getFeature();
        }

        public Background getBackground() {
            ScenarioDefinition background = (ScenarioDefinition)this.getFeature().getChildren().get(0);
            return background instanceof Background ? (Background)background : null;
        }

        public Feature getFeature() {
            return this.currentFeature;
        }

        public URI getUri() {
            return this.currentFeatureUri;
        }

        public Maybe<String> getFeatureId() {
            return this.currentFeatureId;
        }

        public void setFeatureId(Maybe<String> featureId) {
            this.currentFeatureId = featureId;
        }

        public <T extends ScenarioDefinition> T getScenario(TestCase testCase) {
            List featureScenarios = this.getFeature().getChildren();
            for (ScenarioDefinition scenario : featureScenarios) {
                if (scenario instanceof Background) continue;
                if (testCase.getLine().intValue() == scenario.getLocation().getLine() && testCase.getName().equals(scenario.getName())) {
                    return (T)scenario;
                }
                if (!(scenario instanceof ScenarioOutline)) continue;
                for (Examples example : ((ScenarioOutline)scenario).getExamples()) {
                    for (TableRow tableRow : example.getTableBody()) {
                        if (tableRow.getLocation().getLine() != testCase.getLine().intValue()) continue;
                        return (T)scenario;
                    }
                }
            }
            throw new IllegalStateException("Scenario can't be null!");
        }
    }
}

