/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.cucumber;

import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.TokenMatcher;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.reactivex.Maybe;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;

public class RunningContext {
    private RunningContext() {
        throw new AssertionError((Object)"No instances should exist for the class!");
    }

    public static class RuleContext {
        private final String name;
        private final String description;
        private final String keyword;
        private final int line;
        private final URI uri;
        private final TestCase testCase;
        private Maybe<String> id;

        public RuleContext(@Nonnull URI featureUri, @Nonnull Messages.GherkinDocument.Feature.FeatureChild.Rule rule, @Nonnull TestCase ruleTestCase) {
            this.testCase = ruleTestCase;
            this.name = rule.getName();
            this.description = rule.getDescription();
            this.keyword = rule.getKeyword();
            this.line = rule.getLocation().getLine();
            this.uri = featureUri;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Nonnull
        public String getKeyword() {
            return this.keyword;
        }

        public int getLine() {
            return this.line;
        }

        @Nonnull
        public URI getUri() {
            return this.uri;
        }

        public Maybe<String> getId() {
            return this.id;
        }

        public void setId(Maybe<String> id) {
            this.id = id;
        }

        public TestCase getTestCase() {
            return this.testCase;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RuleContext)) {
                return false;
            }
            RuleContext that = (RuleContext)o;
            return this.line == that.line && this.uri.equals(that.uri);
        }

        public int hashCode() {
            return Objects.hash(this.line, this.uri);
        }
    }

    public static class ScenarioContext {
        private static final Map<Messages.GherkinDocument.Feature.Scenario, List<Integer>> scenarioOutlineMap = new ConcurrentHashMap<Messages.GherkinDocument.Feature.Scenario, List<Integer>>();
        private final Queue<Messages.GherkinDocument.Feature.Step> backgroundSteps = new ArrayDeque<Messages.GherkinDocument.Feature.Step>();
        private final Map<Integer, Messages.GherkinDocument.Feature.Step> scenarioLocationMap = new HashMap<Integer, Messages.GherkinDocument.Feature.Step>();
        private Maybe<String> currentStepId;
        private Maybe<String> hookStepId;
        private Status hookStatus;
        private Maybe<String> id;
        private Messages.GherkinDocument.Feature.Background background;
        private Messages.GherkinDocument.Feature.Scenario scenario;
        private TestCase testCase;
        private boolean hasBackground = false;
        private String outlineIteration;
        private URI uri;
        private String text;
        private RuleContext rule;

        public void processScenario(Messages.GherkinDocument.Feature.Scenario scenario) {
            this.scenario = scenario;
            for (Messages.GherkinDocument.Feature.Step step : scenario.getStepsList()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
        }

        public void processBackground(Messages.GherkinDocument.Feature.Background background) {
            if (background != null) {
                this.background = background;
                this.hasBackground = true;
                this.backgroundSteps.addAll(background.getStepsList());
                this.mapBackgroundSteps(background);
            }
        }

        public void processScenarioOutline(Messages.GherkinDocument.Feature.Scenario scenarioOutline) {
            if (this.isScenarioOutline(scenarioOutline)) {
                scenarioOutlineMap.computeIfAbsent(scenarioOutline, k -> scenarioOutline.getExamplesList().stream().flatMap(e -> e.getTableBodyList().stream()).map(r -> r.getLocation().getLine()).collect(Collectors.toList()));
                int iterationIdx = IntStream.range(0, scenarioOutlineMap.get(scenarioOutline).size()).filter(i -> this.getLine() == scenarioOutlineMap.get(scenarioOutline).get(i).intValue()).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No outline iteration number found for scenario %s:%s", this.uri, this.getLine())));
                this.outlineIteration = String.format("[%d]", iterationIdx + 1);
            }
        }

        public void mapBackgroundSteps(Messages.GherkinDocument.Feature.Background background) {
            for (Messages.GherkinDocument.Feature.Step step : background.getStepsList()) {
                this.scenarioLocationMap.put(step.getLocation().getLine(), step);
            }
        }

        public String getName() {
            return this.scenario.getName();
        }

        public String getKeyword() {
            return this.scenario.getKeyword();
        }

        public int getLine() {
            return this.isScenarioOutline(this.scenario) ? this.testCase.getLocation().getLine() : this.scenario.getLocation().getLine();
        }

        public String getStepPrefix() {
            return this.hasBackground() && this.withBackground() ? this.background.getKeyword().toUpperCase() + ": " : "";
        }

        public Messages.GherkinDocument.Feature.Step getStep(TestStep testStep) {
            PickleStepTestStep pickleStepTestStep = (PickleStepTestStep)testStep;
            Messages.GherkinDocument.Feature.Step step = this.scenarioLocationMap.get(pickleStepTestStep.getStep().getLine());
            if (step != null) {
                return step;
            }
            throw new IllegalStateException(String.format("Trying to get step for unknown line in feature. Scenario: %s, line: %s", this.scenario.getName(), this.getLine()));
        }

        public Maybe<String> getId() {
            return this.id;
        }

        public void setId(Maybe<String> newId) {
            if (this.id != null) {
                throw new IllegalStateException("Attempting re-set scenario ID for unfinished scenario: " + this.getName());
            }
            this.id = newId;
        }

        public void setTestCase(TestCase testCase) {
            this.testCase = testCase;
        }

        public void nextBackgroundStep() {
            this.backgroundSteps.poll();
        }

        public boolean isScenarioOutline(Messages.GherkinDocument.Feature.Scenario scenario) {
            return scenario.getExamplesCount() > 0;
        }

        public boolean withBackground() {
            return !this.backgroundSteps.isEmpty();
        }

        public boolean hasBackground() {
            return this.hasBackground && this.background != null;
        }

        public String getOutlineIteration() {
            return this.outlineIteration;
        }

        public Maybe<String> getCurrentStepId() {
            return this.currentStepId;
        }

        public void setCurrentStepId(Maybe<String> currentStepId) {
            this.currentStepId = currentStepId;
        }

        public Maybe<String> getHookStepId() {
            return this.hookStepId;
        }

        public void setHookStepId(Maybe<String> hookStepId) {
            this.hookStepId = hookStepId;
        }

        public Status getHookStatus() {
            return this.hookStatus;
        }

        public void setHookStatus(Status hookStatus) {
            this.hookStatus = hookStatus;
        }

        public void setFeatureUri(URI featureUri) {
            this.uri = featureUri;
        }

        public URI getFeatureUri() {
            return this.uri;
        }

        public void setCurrentText(String stepText) {
            this.text = stepText;
        }

        public String getCurrentText() {
            return this.text;
        }

        public void setRule(RuleContext rule) {
            this.rule = rule;
        }

        public RuleContext getRule() {
            return this.rule;
        }

        public TestCase getTestCase() {
            return this.testCase;
        }
    }

    public static class FeatureContext {
        private static final Map<URI, TestSourceRead> PATH_TO_READ_EVENT_MAP = new ConcurrentHashMap<URI, TestSourceRead>();
        private final URI currentFeatureUri;
        private final Messages.GherkinDocument.Feature currentFeature;
        private Maybe<String> currentFeatureId;
        private RuleContext rule;

        public FeatureContext(TestCase testCase) {
            TestSourceRead event = PATH_TO_READ_EVENT_MAP.get(testCase.getUri());
            this.currentFeature = this.getFeature(event.getSource());
            this.currentFeatureUri = event.getUri();
        }

        public static void addTestSourceReadEvent(URI uri, TestSourceRead event) {
            PATH_TO_READ_EVENT_MAP.put(uri, event);
        }

        public ScenarioContext getScenarioContext(TestCase testCase) {
            Pair<Messages.GherkinDocument.Feature.Scenario, RuleContext> scenario = this.getScenario(testCase);
            ScenarioContext context = new ScenarioContext();
            context.processScenario((Messages.GherkinDocument.Feature.Scenario)scenario.getKey());
            context.setTestCase(testCase);
            context.processBackground(this.getBackground());
            context.processScenarioOutline((Messages.GherkinDocument.Feature.Scenario)scenario.getKey());
            context.setFeatureUri(this.getUri());
            context.setRule((RuleContext)scenario.getValue());
            return context;
        }

        public Messages.GherkinDocument.Feature getFeature(String source) {
            Parser parser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IdGenerator.UUID()));
            TokenMatcher matcher = new TokenMatcher();
            Messages.GherkinDocument gherkinDocument = ((Messages.GherkinDocument.Builder)parser.parse(source, (Parser.ITokenMatcher)matcher)).build();
            return gherkinDocument.getFeature();
        }

        public Messages.GherkinDocument.Feature.Background getBackground() {
            Messages.GherkinDocument.Feature.FeatureChild scenario = this.getFeature().getChildren(0);
            return scenario.hasBackground() ? scenario.getBackground() : null;
        }

        public Messages.GherkinDocument.Feature getFeature() {
            return this.currentFeature;
        }

        public URI getUri() {
            return this.currentFeatureUri;
        }

        public Maybe<String> getFeatureId() {
            return this.currentFeatureId;
        }

        public void setFeatureId(Maybe<String> featureId) {
            this.currentFeatureId = featureId;
        }

        public Pair<Messages.GherkinDocument.Feature.Scenario, RuleContext> getScenario(TestCase testCase) {
            List featureChildren = this.getFeature().getChildrenList();
            for (Messages.GherkinDocument.Feature.FeatureChild child : featureChildren) {
                Messages.GherkinDocument.Feature.FeatureChild.Rule rule;
                Messages.GherkinDocument.Feature.Scenario result;
                Messages.GherkinDocument.Feature.Scenario result2;
                if (child.hasScenario() && (result2 = this.getScenario(child.getScenario(), testCase)) != null) {
                    return Pair.of((Object)result2, null);
                }
                if (!child.hasRule() || (result = this.getScenario(rule = child.getRule(), testCase)) == null) continue;
                return Pair.of((Object)result, (Object)new RuleContext(this.getUri(), rule, testCase));
            }
            throw new IllegalStateException("Scenario can't be null!");
        }

        public Messages.GherkinDocument.Feature.Scenario getScenario(Messages.GherkinDocument.Feature.Scenario scenario, TestCase testCase) {
            if (testCase.getLocation().getLine() == scenario.getLocation().getLine() && testCase.getName().equals(scenario.getName())) {
                return scenario;
            }
            if (scenario.getExamplesCount() > 0) {
                for (Messages.GherkinDocument.Feature.Scenario.Examples example : scenario.getExamplesList()) {
                    for (Messages.GherkinDocument.Feature.TableRow tableRow : example.getTableBodyList()) {
                        if (tableRow.getLocation().getLine() != testCase.getLocation().getLine()) continue;
                        return scenario;
                    }
                }
            }
            return null;
        }

        public Messages.GherkinDocument.Feature.Scenario getScenario(Messages.GherkinDocument.Feature.FeatureChild.Rule rule, TestCase testCase) {
            List ruleChildren = rule.getChildrenList();
            for (Messages.GherkinDocument.Feature.FeatureChild.RuleChild child : ruleChildren) {
                Messages.GherkinDocument.Feature.Scenario result;
                if (!child.hasScenario() || (result = this.getScenario(child.getScenario(), testCase)) == null) continue;
                return result;
            }
            return null;
        }

        public void setCurrentRule(RuleContext rule) {
            this.rule = rule;
        }

        public RuleContext getCurrentRule() {
            return this.rule;
        }
    }
}

