/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.jbehave;

import com.epam.reportportal.jbehave.JBehaveUtils;
import com.epam.reportportal.jbehave.ReportPortalStoryReporter;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.tree.TestItemTree;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;

public abstract class ReportPortalFormat
extends Format {
    private static final ThreadLocal<ReportPortalFormat> INSTANCES = new InheritableThreadLocal<ReportPortalFormat>();
    private static final ThreadLocal<ReportPortalStoryReporter> STORY_REPORTERS = new InheritableThreadLocal<ReportPortalStoryReporter>();
    private static final String SKIPPED_ISSUE_KEY = "skippedIssue";
    private static final String AGENT_PROPERTIES_FILE = "agent.properties";
    protected final MemoizingSupplier<Launch> launch;
    protected final TestItemTree itemTree = new TestItemTree();
    protected final ReportPortal rp;

    public ReportPortalFormat(ReportPortal reportPortal) {
        super("REPORT_PORTAL");
        this.rp = reportPortal;
        this.launch = this.createLaunch(this.rp);
        INSTANCES.set(this);
    }

    public void finishLaunch() {
        FinishExecutionRQ rq = new FinishExecutionRQ();
        rq.setEndTime((Comparable)Instant.now());
        ((Launch)this.launch.get()).finish(rq);
    }

    protected Thread getShutdownHook() {
        return new Thread(this::finishLaunch);
    }

    protected StartLaunchRQ buildStartLaunchRQ(Instant startTime, ListenerParameters parameters) {
        StartLaunchRQ rq = new StartLaunchRQ();
        rq.setName(parameters.getLaunchName());
        rq.setStartTime((Comparable)startTime);
        rq.setMode(parameters.getLaunchRunningMode());
        rq.setAttributes(new HashSet(parameters.getAttributes()));
        rq.setDescription(parameters.getDescription());
        rq.setRerun(parameters.isRerun());
        if (StringUtils.isNotBlank((CharSequence)parameters.getRerunOf())) {
            rq.setRerunOf(parameters.getRerunOf());
        }
        if (null != parameters.getSkippedAnIssue()) {
            ItemAttributesRQ skippedIssueAttribute = new ItemAttributesRQ();
            skippedIssueAttribute.setKey(SKIPPED_ISSUE_KEY);
            skippedIssueAttribute.setValue(parameters.getSkippedAnIssue().toString());
            skippedIssueAttribute.setSystem(true);
            rq.getAttributes().add(skippedIssueAttribute);
        }
        rq.getAttributes().addAll(SystemAttributesExtractor.extract((String)AGENT_PROPERTIES_FILE, (ClassLoader)JBehaveUtils.class.getClassLoader()));
        return rq;
    }

    protected MemoizingSupplier<Launch> createLaunch(final ReportPortal rp) {
        return new MemoizingSupplier((Supplier)new Supplier<Launch>(){
            private final Instant startTime = Instant.now();

            @Override
            public Launch get() {
                ListenerParameters parameters = rp.getParameters();
                StartLaunchRQ rq = ReportPortalFormat.this.buildStartLaunchRQ(this.startTime, parameters);
                Launch myLaunch = rp.newLaunch(rq);
                Runtime.getRuntime().addShutdownHook(ReportPortalFormat.this.getShutdownHook());
                ReportPortalFormat.this.itemTree.setLaunchId(myLaunch.start());
                return myLaunch;
            }
        });
    }

    public StoryReporter createStoryReporter(FilePrintStreamFactory factory, StoryReporterBuilder storyReporterBuilder) {
        ReportPortalStoryReporter reporter = this.createReportPortalReporter(factory, storyReporterBuilder);
        STORY_REPORTERS.set(reporter);
        return reporter;
    }

    protected abstract ReportPortalStoryReporter createReportPortalReporter(FilePrintStreamFactory var1, StoryReporterBuilder var2);

    @Nonnull
    public ReportPortal getReportPortal() {
        return this.rp;
    }

    @Nonnull
    public TestItemTree getItemTree() {
        return this.itemTree;
    }

    @Nonnull
    public static ReportPortalFormat getCurrent() {
        return INSTANCES.get();
    }

    @Nonnull
    public static Optional<ReportPortalStoryReporter> getCurrentStoryReporter() {
        return Optional.ofNullable(STORY_REPORTERS.get());
    }
}

