/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.message;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.MimeTypeDetector;
import java.io.File;
import java.io.IOException;
import rp.com.google.common.io.ByteSource;
import rp.com.google.common.io.Files;

public class ReportPortalMessage {
    private TypeAwareByteSource data;
    private String message;

    public ReportPortalMessage() {
    }

    public ReportPortalMessage(String message) {
        this.message = message;
    }

    public ReportPortalMessage(ByteSource data, String mediaType, String message) {
        this(message);
        this.data = new TypeAwareByteSource(data, mediaType);
    }

    public ReportPortalMessage(TypeAwareByteSource data, String message) {
        this(message);
        this.data = data;
    }

    public ReportPortalMessage(File file, String message) throws IOException {
        this(new TypeAwareByteSource(Files.asByteSource(file), MimeTypeDetector.detect(file)), message);
    }

    public String getMessage() {
        return this.message;
    }

    public TypeAwareByteSource getData() {
        return this.data;
    }
}

