/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.http.proxy;

import com.epam.reportportal.restendpoint.http.HttpClientRestEndpoint;
import com.epam.reportportal.restendpoint.http.RestEndpoint;
import com.epam.reportportal.restendpoint.http.annotation.Close;
import com.epam.reportportal.restendpoint.http.proxy.RestMethodInfo;
import io.reactivex.Maybe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import rp.com.google.common.base.Preconditions;

public class RestEndpointInvocationHandler
implements InvocationHandler {
    public static final HttpClientRestEndpoint.BodyTransformer<Object> BODY_TRANSFORMER = new HttpClientRestEndpoint.BodyTransformer();
    private final Map<Method, RestMethodInfo> restMethods;
    private final RestEndpoint delegate;
    private String closeMethod;

    public RestEndpointInvocationHandler(Class<?> clazz, RestEndpoint restEndpoint) {
        this.delegate = restEndpoint;
        this.restMethods = RestMethodInfo.mapMethods(clazz);
        for (Method m : clazz.getMethods()) {
            if (null == m.getAnnotation(Close.class)) continue;
            this.closeMethod = m.getName();
        }
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.executeRestMethod(method, args);
    }

    private Object executeRestMethod(Method method, Object[] args) throws Throwable {
        Maybe result;
        if (null != this.closeMethod && this.closeMethod.equals(method.getName())) {
            this.delegate.close();
            return null;
        }
        Preconditions.checkState(this.restMethods.containsKey(method), "Method with name [%s] is not mapped", (Object)method.getName());
        RestMethodInfo methodInfo = this.restMethods.get(method);
        Maybe response = this.delegate.executeRequest(methodInfo.createRestCommand(args));
        Maybe maybe = result = methodInfo.isBodyOnly() ? response.flatMap(BODY_TRANSFORMER) : response;
        if (methodInfo.isAsynchronous()) {
            return result;
        }
        return result.blockingGet();
    }
}

