/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.restendpoint.serializer;

import com.epam.reportportal.restendpoint.http.exception.SerializerException;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.net.MediaType;
import rp.com.google.common.reflect.TypeToken;

public class TextSerializer
implements Serializer {
    private final ConvertUtilsBean converter = new ConvertUtilsBean();

    public TextSerializer() {
        this(true, true, 0);
    }

    public TextSerializer(boolean throwException, boolean defaultNull, int defaultArraySize) {
        this.converter.register(throwException, defaultNull, defaultArraySize);
        this.converter.deregister(byte[].class);
        this.converter.deregister(Byte[].class);
    }

    public TextSerializer(Map<Converter, Class<?>> typeConverters) {
        this();
        for (Map.Entry<Converter, Class<?>> typeConverter : typeConverters.entrySet()) {
            this.converter.register(typeConverter.getKey(), typeConverter.getValue());
        }
    }

    @Override
    public <T> byte[] serialize(T t) throws SerializerException {
        try {
            return ((String)this.converter.lookup(String.class).convert(String.class, t)).getBytes(Charsets.UTF_8);
        }
        catch (ConversionException e) {
            throw new SerializerException("Cannot convert content '" + t + "' to string type", e.getCause());
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Class<T> clazz) throws SerializerException {
        String stringContent = new String(content, Charsets.UTF_8);
        try {
            return (T)this.converter.lookup(clazz).convert(clazz, (Object)stringContent);
        }
        catch (ConversionException e) {
            throw new SerializerException("Cannot convert content '" + stringContent + "' to type [" + clazz + "]", e.getCause());
        }
    }

    @Override
    public <T> T deserialize(byte[] content, Type type) throws SerializerException {
        return (T)this.deserialize(content, TypeToken.of(type).getRawType());
    }

    @Override
    public MediaType getMimeType() {
        return MediaType.PLAIN_TEXT_UTF_8;
    }

    @Override
    public boolean canRead(MediaType mimeType, Class<?> resultType) {
        return mimeType.withoutParameters().is(MediaType.ANY_TEXT_TYPE) && null != this.converter.lookup(resultType, String.class);
    }

    @Override
    public boolean canRead(MediaType mimeType, Type resultType) {
        return this.canRead(mimeType, TypeToken.of(resultType).getRawType());
    }

    @Override
    public boolean canWrite(Object o) {
        return null != this.converter.lookup(o.getClass());
    }
}

