/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import rp.com.google.common.base.Strings;
import rp.com.google.common.io.ByteSource;

public class MimeTypeDetector {
    private static Detector detector = new AutoDetectParser().getDetector();

    private MimeTypeDetector() {
    }

    public static String detect(File file) throws IOException {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", file.getName());
        return MimeTypeDetector.detect(TikaInputStream.get((File)file), metadata);
    }

    public static String detect(ByteSource source, String resourceName) throws IOException {
        Metadata metadata = new Metadata();
        if (!Strings.isNullOrEmpty(resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        return MimeTypeDetector.detect(TikaInputStream.get((InputStream)source.openBufferedStream()), metadata);
    }

    public static String detect(TikaInputStream is, Metadata metadata) throws IOException {
        return detector.detect((InputStream)is, metadata).toString();
    }
}

